/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.TransactionContextHelper;

public class TupleContextHelper {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public static TupleContext tupleContext(SharedSessionContractImplementor session, EntityMetadataInformation metadata) {
        if (metadata != null) {
            OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getMetamodel().entityPersister(metadata.getTypeName());
            return persister.getTupleContext(session);
        }
        if (session != null) {
            TransactionContext transactionContext = TransactionContextHelper.transactionContext(session);
            OnlyWithTransactionContext tupleContext = new OnlyWithTransactionContext(transactionContext);
            return tupleContext;
        }
        return null;
    }

    private static class OnlyWithTransactionContext
    implements TupleContext {
        private final TransactionContext transactionContext;

        private OnlyWithTransactionContext(TransactionContext transactionContext) {
            this.transactionContext = transactionContext;
        }

        @Override
        public TransactionContext getTransactionContext() {
            return this.transactionContext;
        }

        @Override
        public TupleTypeContext getTupleTypeContext() {
            throw LOG.tupleContextNotAvailable();
        }

        @Override
        public OperationsQueue getOperationsQueue() {
            throw LOG.tupleContextNotAvailable();
        }
    }
}

