/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.dialect.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableKey;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;

public final class SerializableMapAssociationSnapshot
implements AssociationSnapshot {
    private final Map<SerializableKey, Map<String, Object>> associationMap;

    public SerializableMapAssociationSnapshot(Map<SerializableKey, Map<String, Object>> associationMap) {
        this.associationMap = associationMap;
    }

    public Tuple get(RowKey column) {
        Map<String, Object> rawResult = this.associationMap.get(new SerializableKey((Key)column));
        return rawResult != null ? new Tuple((TupleSnapshot)new MapTupleSnapshot(rawResult)) : null;
    }

    public boolean containsKey(RowKey column) {
        return this.associationMap.containsKey(new SerializableKey((Key)column));
    }

    public int size() {
        return this.associationMap.size();
    }

    public Set<RowKey> getRowKeys() {
        HashSet<RowKey> rowKeys = new HashSet<RowKey>(this.associationMap.size());
        for (SerializableKey key : this.associationMap.keySet()) {
            rowKeys.add(new RowKey(key.getTable(), key.getColumnNames(), key.getColumnValues()));
        }
        return rowKeys;
    }

    public Map<SerializableKey, Map<String, Object>> getUnderlyingMap() {
        return this.associationMap;
    }
}

