/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractObjectOutput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.TraceInformation;

public abstract class AbstractMarshaller
extends AbstractObjectOutput
implements Marshaller {
    protected final ClassExternalizerFactory classExternalizerFactory;
    protected final StreamHeader streamHeader;
    protected final ClassResolver classResolver;
    protected final ObjectResolver objectResolver;
    protected final Creator serializedCreator;
    protected final Creator externalizerCreator;
    protected final ClassTable classTable;
    protected final ObjectTable objectTable;
    protected final ExceptionListener exceptionListener;
    protected final SerializabilityChecker serializabilityChecker;
    protected final int configuredVersion;

    protected AbstractMarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        super(AbstractMarshaller.calcBufferSize(marshallerFactory, configuration));
        ClassExternalizerFactory classExternalizerFactory = configuration.getClassExternalizerFactory();
        this.classExternalizerFactory = classExternalizerFactory == null ? marshallerFactory.getDefaultClassExternalizerFactory() : classExternalizerFactory;
        StreamHeader streamHeader = configuration.getStreamHeader();
        this.streamHeader = streamHeader == null ? marshallerFactory.getDefaultStreamHeader() : streamHeader;
        ClassResolver classResolver = configuration.getClassResolver();
        this.classResolver = classResolver == null ? marshallerFactory.getDefaultClassResolver() : classResolver;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectResolver;
        Creator serializedCreator = configuration.getSerializedCreator();
        this.serializedCreator = serializedCreator == null ? marshallerFactory.getDefaultSerializedCreator() : serializedCreator;
        Creator externalizedCreator = configuration.getExternalizerCreator();
        this.externalizerCreator = externalizedCreator == null ? marshallerFactory.getDefaultExternalizedCreator() : externalizedCreator;
        ClassTable classTable = configuration.getClassTable();
        this.classTable = classTable == null ? marshallerFactory.getDefaultClassTable() : classTable;
        ObjectTable objectTable = configuration.getObjectTable();
        this.objectTable = objectTable == null ? marshallerFactory.getDefaultObjectTable() : objectTable;
        ExceptionListener exceptionListener = configuration.getExceptionListener();
        this.exceptionListener = exceptionListener == null ? ExceptionListener.NO_OP : exceptionListener;
        SerializabilityChecker serializabilityChecker = configuration.getSerializabilityChecker();
        this.serializabilityChecker = serializabilityChecker == null ? SerializabilityChecker.DEFAULT : serializabilityChecker;
        int configuredVersion = configuration.getVersion();
        this.configuredVersion = configuredVersion == -1 ? marshallerFactory.getDefaultVersion() : configuredVersion;
    }

    private static int calcBufferSize(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        int minBufSize = marshallerFactory.getMinimumBufferSize();
        int bufferSize = configuration.getBufferSize();
        return bufferSize == -1 ? marshallerFactory.getDefaultBufferSize() : (bufferSize < minBufSize ? minBufSize : bufferSize);
    }

    @Override
    public void start(ByteOutput byteOutput) throws IOException {
        this.byteOutput = byteOutput;
        this.buffer = new byte[this.bufferSize];
        this.streamHeader.writeHeader(this);
    }

    @Override
    public final void writeObjectUnshared(Object obj) throws IOException {
        try {
            super.writeObjectUnshared(obj);
        }
        catch (IOException e) {
            TraceInformation.addObjectInformation(e, obj);
            this.exceptionListener.handleMarshallingException(e, obj);
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addObjectInformation(e, obj);
            this.exceptionListener.handleMarshallingException(e, obj);
            throw e;
        }
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        try {
            super.writeObject(obj);
        }
        catch (IOException e) {
            TraceInformation.addObjectInformation(e, obj);
            this.exceptionListener.handleMarshallingException(e, obj);
            throw e;
        }
        catch (RuntimeException e) {
            TraceInformation.addObjectInformation(e, obj);
            this.exceptionListener.handleMarshallingException(e, obj);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        try {
            super.finish();
        }
        finally {
            this.clearClassCache();
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }
}

