/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.params;

import java.util.ArrayList;
import org.apache.lucene.facet.index.categorypolicy.DefaultOrdinalPolicy;
import org.apache.lucene.facet.index.categorypolicy.DefaultPathPolicy;
import org.apache.lucene.facet.index.categorypolicy.OrdinalPolicy;
import org.apache.lucene.facet.index.categorypolicy.PathPolicy;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFacetIndexingParams
implements FacetIndexingParams {
    public static final char DEFAULT_FACET_DELIM_CHAR = '\uf749';
    private final CategoryListParams clpParams;
    private final OrdinalPolicy ordinalPolicy;
    private final PathPolicy pathPolicy;
    private final int partitionSize;

    public DefaultFacetIndexingParams() {
        this(new CategoryListParams());
    }

    public DefaultFacetIndexingParams(CategoryListParams categoryListParams) {
        this.clpParams = categoryListParams;
        this.ordinalPolicy = this.fixedOrdinalPolicy();
        this.pathPolicy = this.fixedPathPolicy();
        this.partitionSize = this.fixedPartitionSize();
    }

    @Override
    public CategoryListParams getCategoryListParams(CategoryPath category) {
        return this.clpParams;
    }

    @Override
    public int drillDownTermText(CategoryPath path, char[] buffer) {
        return path.copyToCharArray(buffer, 0, -1, this.getFacetDelimChar());
    }

    protected int fixedPartitionSize() {
        return Integer.MAX_VALUE;
    }

    protected OrdinalPolicy fixedOrdinalPolicy() {
        return new DefaultOrdinalPolicy();
    }

    protected PathPolicy fixedPathPolicy() {
        return new DefaultPathPolicy();
    }

    @Override
    public final int getPartitionSize() {
        return this.partitionSize;
    }

    @Override
    public Iterable<CategoryListParams> getAllCategoryListParams() {
        ArrayList<CategoryListParams> res = new ArrayList<CategoryListParams>();
        res.add(this.clpParams);
        return res;
    }

    @Override
    public final OrdinalPolicy getOrdinalPolicy() {
        return this.ordinalPolicy;
    }

    @Override
    public final PathPolicy getPathPolicy() {
        return this.pathPolicy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clpParams == null ? 0 : this.clpParams.hashCode());
        result = 31 * result + (this.ordinalPolicy == null ? 0 : this.ordinalPolicy.hashCode());
        result = 31 * result + this.partitionSize;
        result = 31 * result + (this.pathPolicy == null ? 0 : this.pathPolicy.hashCode());
        for (CategoryListParams clp : this.getAllCategoryListParams()) {
            result ^= clp.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFacetIndexingParams)) {
            return false;
        }
        DefaultFacetIndexingParams other = (DefaultFacetIndexingParams)obj;
        if (this.clpParams == null ? other.clpParams != null : !this.clpParams.equals(other.clpParams)) {
            return false;
        }
        if (this.ordinalPolicy == null ? other.ordinalPolicy != null : !this.ordinalPolicy.equals(other.ordinalPolicy)) {
            return false;
        }
        if (this.partitionSize != other.partitionSize) {
            return false;
        }
        if (this.pathPolicy == null ? other.pathPolicy != null : !this.pathPolicy.equals(other.pathPolicy)) {
            return false;
        }
        Iterable<CategoryListParams> cLs = this.getAllCategoryListParams();
        Iterable<CategoryListParams> otherCLs = other.getAllCategoryListParams();
        return cLs.equals(otherCLs);
    }

    @Override
    public char getFacetDelimChar() {
        return '\uf749';
    }
}

