/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;

public class ScoredDocIdsUtils {
    public static final ScoredDocIDs getComplementSet(ScoredDocIDs docids, IndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        DocIdSet docIdSet = docids.getDocIDs();
        Object complement = docIdSet instanceof OpenBitSet ? (OpenBitSet)((OpenBitSet)docIdSet).clone() : new OpenBitSetDISI(docIdSet.iterator(), maxDoc);
        complement.flip(0L, (long)maxDoc);
        ScoredDocIdsUtils.clearDeleted(reader, complement);
        return ScoredDocIdsUtils.createScoredDocIds((DocIdSet)complement, maxDoc);
    }

    private static void clearDeleted(IndexReader reader, OpenBitSet set) throws IOException {
        if (!reader.hasDeletions()) {
            return;
        }
        DocIdSetIterator it = set.iterator();
        int doc = Integer.MAX_VALUE;
        while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
            if (!reader.isDeleted(doc)) continue;
            set.fastClear(doc);
        }
    }

    public static final ScoredDocIDs createScoredDocIDsSubset(ScoredDocIDs allDocIds, int[] sampleSet) throws IOException {
        final int[] docids = sampleSet;
        Arrays.sort(docids);
        final float[] scores = new float[docids.length];
        ScoredDocIDsIterator it = allDocIds.iterator();
        int n = 0;
        while (it.next() && n < docids.length) {
            int doc = it.getDocID();
            if (doc != docids[n]) continue;
            scores[n] = it.getScore();
            ++n;
        }
        final int size = n;
        return new ScoredDocIDs(){

            public DocIdSet getDocIDs() {
                return new DocIdSet(){

                    public boolean isCacheable() {
                        return true;
                    }

                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            private int next = -1;

                            public int advance(int target) throws IOException {
                                while (this.next < size && docids[this.next++] < target) {
                                }
                                return this.next == size ? Integer.MAX_VALUE : docids[this.next];
                            }

                            public int docID() {
                                return docids[this.next];
                            }

                            public int nextDoc() throws IOException {
                                if (++this.next >= size) {
                                    return Integer.MAX_VALUE;
                                }
                                return docids[this.next];
                            }
                        };
                    }
                };
            }

            public ScoredDocIDsIterator iterator() throws IOException {
                return new ScoredDocIDsIterator(){
                    int next = -1;

                    public boolean next() {
                        return ++this.next < size;
                    }

                    public float getScore() {
                        return scores[this.next];
                    }

                    public int getDocID() {
                        return docids[this.next];
                    }
                };
            }

            public int size() {
                return size;
            }
        };
    }

    public static final ScoredDocIDs createAllDocsScoredDocIDs(IndexReader reader) {
        if (reader.hasDeletions()) {
            return new AllLiveDocsScoredDocIDs(reader);
        }
        return new AllDocsScoredDocIDs(reader);
    }

    public static final ScoredDocIDs createScoredDocIds(final DocIdSet docIdSet, final int maxDoc) {
        return new ScoredDocIDs(){
            private int size = -1;

            public DocIdSet getDocIDs() {
                return docIdSet;
            }

            public ScoredDocIDsIterator iterator() throws IOException {
                final DocIdSetIterator docIterator = docIdSet.iterator();
                return new ScoredDocIDsIterator(){

                    public boolean next() {
                        try {
                            return docIterator.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public float getScore() {
                        return 1.0f;
                    }

                    public int getDocID() {
                        return docIterator.docID();
                    }
                };
            }

            public int size() {
                if (this.size < 0) {
                    OpenBitSetDISI openBitSetDISI;
                    try {
                        openBitSetDISI = new OpenBitSetDISI(docIdSet.iterator(), maxDoc);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.size = (int)openBitSetDISI.cardinality();
                }
                return this.size;
            }
        };
    }

    private static final class AllLiveDocsScoredDocIDs
    implements ScoredDocIDs {
        final int maxDoc;
        final IndexReader reader;

        AllLiveDocsScoredDocIDs(IndexReader reader) {
            this.maxDoc = reader.maxDoc();
            this.reader = reader;
        }

        public int size() {
            return this.reader.numDocs();
        }

        public DocIdSet getDocIDs() {
            return new DocIdSet(){

                public boolean isCacheable() {
                    return true;
                }

                public DocIdSetIterator iterator() throws IOException {
                    return new DocIdSetIterator(){
                        private int next = -1;

                        public int advance(int target) throws IOException {
                            if (target > this.next) {
                                this.next = target - 1;
                            }
                            return this.nextDoc();
                        }

                        public int docID() {
                            return this.next;
                        }

                        public int nextDoc() throws IOException {
                            do {
                                ++this.next;
                            } while (this.next < AllLiveDocsScoredDocIDs.this.maxDoc && AllLiveDocsScoredDocIDs.this.reader.isDeleted(this.next));
                            return this.next < AllLiveDocsScoredDocIDs.this.maxDoc ? this.next : Integer.MAX_VALUE;
                        }
                    };
                }
            };
        }

        public ScoredDocIDsIterator iterator() {
            try {
                final DocIdSetIterator iter = this.getDocIDs().iterator();
                return new ScoredDocIDsIterator(){

                    public boolean next() {
                        try {
                            return iter.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }

                    public float getScore() {
                        return 1.0f;
                    }

                    public int getDocID() {
                        return iter.docID();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AllDocsScoredDocIDs
    implements ScoredDocIDs {
        final int maxDoc;

        public AllDocsScoredDocIDs(IndexReader reader) {
            this.maxDoc = reader.maxDoc();
        }

        public int size() {
            return this.maxDoc;
        }

        public DocIdSet getDocIDs() {
            return new DocIdSet(){

                public boolean isCacheable() {
                    return true;
                }

                public DocIdSetIterator iterator() throws IOException {
                    return new DocIdSetIterator(){
                        private int next = -1;

                        public int advance(int target) throws IOException {
                            if (target <= this.next) {
                                target = this.next + 1;
                            }
                            this.next = target >= AllDocsScoredDocIDs.this.maxDoc ? Integer.MAX_VALUE : target;
                            return this.next;
                        }

                        public int docID() {
                            return this.next;
                        }

                        public int nextDoc() throws IOException {
                            return ++this.next < AllDocsScoredDocIDs.this.maxDoc ? this.next : Integer.MAX_VALUE;
                        }
                    };
                }
            };
        }

        public ScoredDocIDsIterator iterator() {
            try {
                final DocIdSetIterator iter = this.getDocIDs().iterator();
                return new ScoredDocIDsIterator(){

                    public boolean next() {
                        try {
                            return iter.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }

                    public float getScore() {
                        return 1.0f;
                    }

                    public int getDocID() {
                        return iter.docID();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

