/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import org.hibernate.AssertionFailure;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.ogm.util.impl.StringHelper;

public class OgmNamingStrategy
extends EJB3NamingStrategy {
    public static final NamingStrategy INSTANCE = new OgmNamingStrategy();
    private static final String ELEMENT_COLLECTION_NAME_PATTERN = "collection&&element";

    private String addPropertySeparator(String name) {
        return name;
    }

    public String propertyToColumnName(String propertyName) {
        if (propertyName.contains(ELEMENT_COLLECTION_NAME_PATTERN)) {
            propertyName = propertyName.substring(propertyName.lastIndexOf(".") + 1);
        }
        return this.addPropertySeparator(propertyName);
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.tableName(ownerEntityTable + "_" + (associatedEntityTable != null ? associatedEntityTable : this.addPropertySeparator(propertyName)));
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = propertyName != null ? this.addPropertySeparator(propertyName) : propertyTableName;
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        return this.columnName(header + "_" + referencedColumnName);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return !StringHelper.isEmpty(columnName) ? columnName : propertyName;
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return new StringBuffer(ownerEntityTable).append("_").append(associatedEntityTable != null ? associatedEntityTable : propertyName).toString();
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return !StringHelper.isEmpty(columnName) ? columnName : propertyName + "_" + referencedColumn;
    }
}

