/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.util.impl.CoreLogCategories;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class GridDialectLogger
implements GridDialect,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)CoreLogCategories.DATASTORE_ACCESS.toString());
    private final GridDialect gridDialect;

    public GridDialectLogger(GridDialect gridDialect) {
        if (gridDialect == null) {
            throw new IllegalArgumentException("GridDialect should never be null");
        }
        this.gridDialect = gridDialect;
    }

    public static boolean activationNeeded() {
        return log.isTraceEnabled();
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return this.gridDialect.getLockingStrategy(lockable, lockMode);
    }

    @Override
    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Reading Tuple with key %1$s and context %2$s", key, tupleContext.toString());
        return this.gridDialect.getTuple(key, tupleContext);
    }

    @Override
    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Build Tuple object with key %1$s (does not trigger access to the datastore)", key);
        return this.gridDialect.createTuple(key, tupleContext);
    }

    @Override
    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        if (tuple.getSnapshot().isEmpty()) {
            log.tracef("Creating Tuple with key %1$s in datastore", key);
        } else {
            log.tracef("Updating Tuple with key %1$s in datastore", key);
        }
        this.gridDialect.updateTuple(tuple, key, tupleContext);
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Removing Tuple with key %1$s from datastore", key);
        this.gridDialect.removeTuple(key, tupleContext);
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Reading association with key %1$s from datastore and context %2$s", key, associationContext);
        return this.gridDialect.getAssociation(key, associationContext);
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Build association object with key %1$s (does not trigger access to the datastore)", key);
        return this.gridDialect.createAssociation(key, associationContext);
    }

    @Override
    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        if (association.getSnapshot().size() == 0) {
            log.tracef("Creating association with key %1$s in datastore", key);
        } else {
            log.tracef("Updating association with key %1$s in datastore", key);
        }
        this.gridDialect.updateAssociation(association, key, associationContext);
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Removing association with key %1$s from datastore", key);
        this.gridDialect.removeAssociation(key, associationContext);
    }

    @Override
    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        log.tracef("Build Tuple object for row key entry %1$s in association %2$s (does not trigger access to the datastore)", rowKey, associationKey);
        return this.gridDialect.createTupleAssociation(associationKey, rowKey);
    }

    @Override
    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        log.tracef("Extracting next value from key %1$s", key);
        this.gridDialect.nextValue(key, value, increment, initialValue);
    }

    @Override
    public GridType overrideType(Type type) {
        return this.gridDialect.overrideType(type);
    }

    @Override
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        this.gridDialect.forEachTuple(consumer, entityKeyMetadatas);
    }

    @Override
    public Iterator<Tuple> executeBackendQuery(CustomQuery customQuery, EntityKeyMetadata[] metadatas) {
        log.tracef("Executing native backend query: %1$s", customQuery.getSQL());
        return this.gridDialect.executeBackendQuery(customQuery, metadatas);
    }

    @Override
    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        log.tracef("Determining whether assocication %1$s is stored in an entity structure", associationKey);
        return this.gridDialect.isStoredInEntityStructure(associationKey, associationContext);
    }

    public void configure(Map configurationValues) {
        if (this.gridDialect instanceof Configurable) {
            log.tracef("Configuring service with properties: %1$s", configurationValues);
            ((Configurable)this.gridDialect).configure(configurationValues);
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        if (this.gridDialect instanceof ServiceRegistryAwareService) {
            log.tracef("Injecting service registry", new Object[0]);
            ((ServiceRegistryAwareService)this.gridDialect).injectServices(serviceRegistry);
        }
    }
}

