/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.util.Arrays;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.Key;

public final class AssociationKey
implements Key {
    private final AssociationKeyMetadata metadata;
    private final Object[] columnValues;
    private final int hashCode;
    private final String collectionRole;
    private final EntityKey entityKey;
    private final AssociationKind associationKind;

    public AssociationKey(AssociationKeyMetadata metadata, Object[] columnValues, String collectionRole, EntityKey entityKey, AssociationKind associationKind) {
        this.metadata = metadata;
        if (metadata.getColumnNames().length != columnValues.length) {
            throw new AssertionFailure("Column names do not match column values");
        }
        this.columnValues = columnValues;
        this.collectionRole = collectionRole;
        this.entityKey = entityKey;
        this.associationKind = associationKind;
        this.hashCode = metadata.hashCode() * 31 + Arrays.hashCode(columnValues);
    }

    @Override
    public String getTable() {
        return this.metadata.getTable();
    }

    @Override
    public String[] getColumnNames() {
        return this.metadata.getColumnNames();
    }

    @Override
    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    public AssociationKind getAssociationKind() {
        return this.associationKind;
    }

    public String[] getRowKeyColumnNames() {
        return this.metadata.getRowKeyColumnNames();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || AssociationKey.class != o.getClass()) {
            return false;
        }
        AssociationKey that = (AssociationKey)o;
        if (!this.metadata.getTable().equals(that.metadata.getTable())) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, that.columnValues)) {
            return false;
        }
        return Arrays.equals(this.metadata.getColumnNames(), that.metadata.getColumnNames());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociationKey");
        sb.append("{table='").append(this.metadata.getTable()).append('\'');
        String[] columnNames = this.metadata.getColumnNames();
        sb.append(", columnNames=").append(columnNames == null ? "null" : Arrays.asList(columnNames).toString());
        sb.append(", columnValues=").append(this.columnValues == null ? "null" : Arrays.asList(this.columnValues).toString());
        sb.append('}');
        return sb.toString();
    }

    public boolean isKeyColumn(String columnName) {
        for (String keyColumName : this.getColumnNames()) {
            if (!keyColumName.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public Object getColumnValue(String columnName) {
        for (int i = 0; i < this.getColumnNames().length; ++i) {
            String name = this.getColumnNames()[i];
            if (!name.equals(columnName)) continue;
            return this.getColumnValues()[i];
        }
        throw new AssertionFailure(String.format("Given column %s is not part of this key: %s", columnName, this.toString()));
    }
}

