/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.BackendCustomLoader;
import org.hibernate.ogm.hibernatecore.impl.OgmQuery;
import org.hibernate.ogm.hibernatecore.impl.OgmSharedSessionBuilderDelegator;
import org.hibernate.ogm.jpa.impl.NoSQLQuery;
import org.hibernate.ogm.loader.nativeloader.BackendCustomQuery;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.type.Type;

public class OgmSession
extends SessionDelegatorBaseImpl
implements Session,
EventSource {
    private static final Log log = LoggerFactory.make();
    private static final ParameterMetadata NO_PARAMETERS = new ParameterMetadata(null, null);
    private final EventSource delegate;
    private final OgmSessionFactory factory;
    private QueryParserService queryParserService;

    public OgmSession(OgmSessionFactory factory, EventSource delegate) {
        super((SessionImplementor)delegate, (Session)delegate);
        this.delegate = delegate;
        this.factory = factory;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public OgmSessionFactory getSessionFactory() {
        return this.factory;
    }

    public Criteria createCriteria(Class persistentClass) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Query createQuery(String queryString) throws HibernateException {
        this.errorIfClosed();
        Map enabledFilters = Collections.EMPTY_MAP;
        try {
            HQLQueryPlan plan = new HQLQueryPlan(queryString, false, enabledFilters, (SessionFactoryImplementor)this.factory);
            ParameterMetadata parameterMetadata = plan.getParameterMetadata();
            OgmQuery query = new OgmQuery(queryString, this.getFlushMode(), this, parameterMetadata, this.getQueryParserService());
            query.setComment(queryString);
            return query;
        }
        catch (QuerySyntaxException qse) {
            throw log.querySyntaxException(qse, queryString);
        }
    }

    public Query createQuery(NamedQueryDefinition namedQueryDefinition) {
        String queryString = namedQueryDefinition.getQueryString();
        Query query = this.createQuery(queryString);
        query.setComment("named HQL/JP-QL query " + namedQueryDefinition.getName());
        query.setFlushMode(namedQueryDefinition.getFlushMode());
        return query;
    }

    private QueryParserService getQueryParserService() {
        if (this.queryParserService == null) {
            this.queryParserService = (QueryParserService)this.getSessionFactory().getServiceRegistry().getService(QueryParserService.class);
        }
        return this.queryParserService;
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return new NoSQLQuery(queryString, (SessionImplementor)this, NO_PARAMETERS);
    }

    public SQLQuery createSQLQuery(NamedSQLQueryDefinition namedQueryDefinition) {
        return new NoSQLQuery(namedQueryDefinition, (SessionImplementor)this, NO_PARAMETERS);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        throw new NotSupportedException("OGM-24", "filters are not supported yet");
    }

    public Filter enableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public void doWork(Work work) throws HibernateException {
        throw new IllegalStateException("Hibernate OGM does not support SQL Connections hence no Work");
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.delegate.doReturningWork(work);
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ActionQueue getActionQueue() {
        return this.delegate.getActionQueue();
    }

    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        return this.delegate.instantiate(persister, id);
    }

    public void forceFlush(EntityEntry e) throws HibernateException {
        this.delegate.forceFlush(e);
    }

    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.delegate.merge(entityName, object, copiedAlready);
    }

    public void persist(String entityName, Object object, Map createdAlready) throws HibernateException {
        this.delegate.persist(entityName, object, createdAlready);
    }

    public void persistOnFlush(String entityName, Object object, Map copiedAlready) {
        this.delegate.persistOnFlush(entityName, object, copiedAlready);
    }

    public void refresh(String entityName, Object object, Map refreshedAlready) throws HibernateException {
        this.delegate.refresh(entityName, object, refreshedAlready);
    }

    public void delete(String entityName, Object child, boolean isCascadeDeleteEnabled, Set transientEntities) {
        this.delegate.delete(entityName, child, isCascadeDeleteEnabled, transientEntities);
    }

    public JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.delegate.getJdbcConnectionAccess();
    }

    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return this.delegate.generateEntityKey(id, persister);
    }

    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        return this.delegate.generateCacheKey(id, type, entityOrRoleName);
    }

    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        if (log.isTraceEnabled()) {
            log.tracev("NoSQL query: {0}", customQuery.getSQL());
        }
        BackendCustomLoader loader = new BackendCustomLoader(customQuery, this.getFactory());
        return loader.list((SessionImplementor)this.getDelegate(), queryParameters);
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scrollCustomQuery(customQuery, queryParameters);
    }

    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        BackendCustomQuery customQuery = new BackendCustomQuery(spec.getQueryString(), spec.getQueryReturns(), spec.getQuerySpaces(), this.factory);
        return this.listCustomQuery(customQuery, queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scroll(spec, queryParameters);
    }

    public Query getNamedQuery(String name) {
        this.errorIfClosed();
        NamedQueryDefinition namedQuery = this.factory.getNamedQuery(name);
        if (namedQuery == null) {
            return this.getNamedSQLQuery(name);
        }
        return this.createQuery(namedQuery);
    }

    public Query getNamedSQLQuery(String queryName) {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.findNamedNativeQuery(queryName);
        NoSQLQuery query = new NoSQLQuery(nsqlqd, (SessionImplementor)this, NO_PARAMETERS);
        query.setComment("named native query " + queryName);
        return query;
    }

    private NamedSQLQueryDefinition findNamedNativeQuery(String queryName) {
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named native query not found: " + queryName);
        }
        return nsqlqd;
    }

    public SharedSessionBuilder sessionWithOptions() {
        return new OgmSharedSessionBuilderDelegator(this.delegate.sessionWithOptions(), this.factory);
    }

    protected void errorIfClosed() {
        if (this.delegate.isClosed()) {
            throw new SessionException("Session is closed!");
        }
    }

    public <G extends GlobalContext<?, ?>, D extends DatastoreConfiguration<G>> G configureDatastore(Class<D> datastoreType) {
        throw new UnsupportedOperationException("OGM-343 Session specific options are not currently supported");
    }

    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        this.delegate.removeOrphanBeforeUpdates(entityName, child);
    }

    public EventSource getDelegate() {
        return this.delegate;
    }
}

