/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.service.impl.BaseQueryParserService;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class LuceneBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.make();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    @Override
    public Query getParsedQueryExecutor(OgmSession session, String queryString, Map<String, Object> namedParameters) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        LuceneQueryParsingResult parsingResult = (LuceneQueryParsingResult)new QueryParser().parseQuery(queryString, (AstProcessingChain)this.createProcessingChain(session, this.unwrap(namedParameters), fullTextSession));
        log.createdQuery(queryString, parsingResult.getQuery());
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(parsingResult.getQuery(), new Class[]{parsingResult.getTargetEntity()});
        if (this.requiresProjections(parsingResult.getProjections())) {
            fullTextQuery.setProjection(parsingResult.getProjections().toArray(new String[parsingResult.getProjections().size()]));
        }
        fullTextQuery.initializeObjectsWith(ObjectLookupMethod.SKIP, DatabaseRetrievalMethod.FIND_BY_ID);
        return fullTextQuery;
    }

    private boolean requiresProjections(List<String> projections) {
        if (projections.size() == 0) {
            return false;
        }
        return projections.size() != 1 || !"__HSearch_This".equals(projections.get(0));
    }

    private LuceneProcessingChain createProcessingChain(Session session, Map<String, Object> namedParameters, FullTextSession fullTextSession) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames(session.getSessionFactory());
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        return new LuceneProcessingChain.Builder((SearchFactoryIntegrator)searchFactory, entityNamesResolver).namedParameters(namedParameters).buildProcessingChainForClassBasedEntities();
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }
}

