/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type;

import org.hibernate.HibernateException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.type.GridTypeDelegatingToCoreType;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;

public class EnumType
extends GridTypeDelegatingToCoreType {
    private static final Log log = LoggerFactory.make();
    private org.hibernate.type.EnumType coreEnumType;
    private final boolean isOrdinal;
    private volatile transient Enum[] enumValues;

    public EnumType(CustomType customType, org.hibernate.type.EnumType enumType) {
        super((Type)customType);
        this.coreEnumType = enumType;
        this.isOrdinal = this.isOrdinal(this.coreEnumType.sqlTypes()[0]);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        if (names.length > 1) {
            throw new NotYetImplementedException("Multi column property not implemented yet");
        }
        return this.nullSafeGet(rs, names[0], session, owner);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String name, SessionImplementor session, Object owner) throws HibernateException {
        Object object = rs.get(name);
        if (object == null) {
            log.tracef("found [null] as column [$s]", name);
            return null;
        }
        log.tracef("found [$s] as column [$s]", object, name);
        if (object instanceof Integer) {
            this.initEnumValues();
            int ordinal = (Integer)object;
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.coreEnumType.returnedClass() + ": " + ordinal);
            }
            return this.enumValues[ordinal];
        }
        try {
            return Enum.valueOf(this.coreEnumType.returnedClass(), object.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.coreEnumType.returnedClass() + ": " + name, iae);
        }
    }

    private void initEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = (Enum[])this.coreEnumType.returnedClass().getEnumConstants();
            if (this.enumValues == null) {
                throw new NullPointerException("Failed to init enumValues");
            }
        }
    }

    @Override
    public Object hydrate(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        return this.nullSafeGet(rs, names, session, owner);
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, boolean[] settable, SessionImplementor session) throws HibernateException {
        if (settable.length > 1) {
            throw new NotYetImplementedException("Multi column property not implemented yet");
        }
        if (settable[0]) {
            this.nullSafeSet(resultset, value, names, session);
        }
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, SessionImplementor session) throws HibernateException {
        if (names.length > 1) {
            throw new NotYetImplementedException("Multi column property not implemented yet");
        }
        if (value == null) {
            log.tracef("binding [null] to parameter [$s]", names[0]);
        } else {
            Object endValue = this.isOrdinal ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
            log.tracef("binding [$s] to parameter(s) $s", endValue, names[0]);
            resultset.put(names[0], endValue);
        }
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }
}

