/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.CollectionPhysicalModel;
import org.hibernate.ogm.persister.EntityKeyBuilder;
import org.hibernate.ogm.persister.OgmCollectionPersister;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class AssociationPersister {
    private GridType keyGridType;
    private Object key;
    private SessionImplementor session;
    private AssociationKey associationKey;
    private Association association;
    private Object[] columnValues;
    private GridDialect gridDialect;
    private OgmCollectionPersister collectionPersister;
    private boolean inverse;
    private Type propertyType;
    private AssociationContext associationContext;
    private Boolean isBidirectional;
    private AssociationKeyMetadata associationKeyMetadata;
    private final Class<?> hostingEntityType;
    private Object hostingEntity;
    private Boolean hostingEntityRequiresReadAfterUpdate;
    private EntityPersister hostingEntityPersister;

    public AssociationPersister(Class<?> entityType) {
        this.hostingEntityType = entityType;
    }

    public AssociationPersister gridDialect(GridDialect gridDialect) {
        this.gridDialect = gridDialect;
        return this;
    }

    public AssociationPersister keyGridType(GridType keyGridType) {
        this.keyGridType = keyGridType;
        return this;
    }

    public AssociationPersister session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public AssociationPersister key(Object key) {
        this.key = key;
        return this;
    }

    public AssociationPersister keyColumnValues(Object[] columnValues) {
        this.columnValues = columnValues;
        return this;
    }

    public AssociationPersister inverse() {
        this.inverse = true;
        return this;
    }

    public AssociationPersister hostingEntity(Object entity) {
        this.hostingEntity = entity;
        return this;
    }

    public AssociationPersister collectionPersister(OgmCollectionPersister collectionPersister) {
        this.collectionPersister = collectionPersister;
        return this;
    }

    public AssociationPersister propertyType(Type type) {
        this.propertyType = type;
        return this;
    }

    public AssociationPersister associationKeyMetadata(AssociationKeyMetadata associationKeyMetadata) {
        this.associationKeyMetadata = associationKeyMetadata;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AssociationKey getAssociationKey() {
        if (this.associationKey != null) return this.associationKey;
        Object[] columnValues = this.getKeyColumnValues();
        String collectionRole = null;
        EntityKey ownerEntityKey = null;
        AssociationKind associationKind = null;
        if (this.collectionPersister != null) {
            AssociationKind type;
            EntityKey entityKey;
            if (this.inverse) {
                OgmEntityPersister elementPersister = (OgmEntityPersister)this.collectionPersister.getElementPersister();
                entityKey = EntityKeyBuilder.fromPersister(elementPersister, (Serializable)this.key, this.session);
                collectionRole = this.buildCollectionRole(this.collectionPersister);
            } else {
                collectionRole = this.getUnqualifiedRole(this.collectionPersister);
                entityKey = EntityKeyBuilder.fromPersister((OgmEntityPersister)this.collectionPersister.getOwnerEntityPersister(), (Serializable)this.key, this.session);
            }
            ownerEntityKey = entityKey;
            associationKind = type = this.collectionPersister.getElementType().isEntityType() ? AssociationKind.ASSOCIATION : AssociationKind.EMBEDDED_COLLECTION;
        } else {
            EntityKey entityKey;
            if (this.propertyType == null) throw new AssertionFailure("Cannot detect associated entity metadata: collectionPersister and propertyType are both null");
            AssociationKind associationKind2 = associationKind = this.propertyType.isEntityType() ? AssociationKind.ASSOCIATION : AssociationKind.EMBEDDED_COLLECTION;
            if (!(this.propertyType instanceof EntityType)) throw new AssertionFailure("Cannot detect associated entity metadata. propertyType is of unexpected type: " + this.propertyType.getClass());
            EntityType entityType = (EntityType)this.propertyType;
            OgmEntityPersister associatedPersister = (OgmEntityPersister)entityType.getAssociatedJoinable(this.session.getFactory());
            ownerEntityKey = entityKey = new EntityKey(associatedPersister.getEntityKeyMetadata(), columnValues);
            collectionRole = this.getCollectionRoleFromToOne(associatedPersister);
        }
        this.associationKey = new AssociationKey(this.associationKeyMetadata, columnValues, collectionRole, ownerEntityKey, associationKind);
        return this.associationKey;
    }

    private String getCollectionRoleFromToOne(OgmEntityPersister associatedPersister) {
        Type[] propertyTypes = associatedPersister.getPropertyTypes();
        String otherSidePropertyName = null;
        for (int index = 0; index < propertyTypes.length; ++index) {
            Type type = propertyTypes[index];
            boolean matching = false;
            if (type.isAssociationType() && type.isCollectionType()) {
                matching = this.isCollectionMatching((CollectionType)type, this.associationKeyMetadata.getTable());
            } else if (type.isAssociationType() && !type.isCollectionType()) {
                matching = this.isToOneMatching((Loadable)associatedPersister, index, type);
            }
            if (!matching) continue;
            otherSidePropertyName = associatedPersister.getPropertyNames()[index];
            break;
        }
        return this.processOtherSidePropertyName(otherSidePropertyName);
    }

    private boolean isCollectionMatching(CollectionType type, String primarySideTableName) {
        String collectionRole = type.getRole();
        CollectionPhysicalModel reverseCollectionPersister = (CollectionPhysicalModel)this.session.getFactory().getCollectionPersister(collectionRole);
        boolean isSameTable = primarySideTableName.equals(reverseCollectionPersister.getTableName());
        return isSameTable && Arrays.equals(this.associationKeyMetadata.getColumnNames(), reverseCollectionPersister.getKeyColumnNames());
    }

    private String buildCollectionRole(OgmCollectionPersister collectionPersister) {
        String otherSidePropertyName = null;
        Loadable elementPersister = (Loadable)collectionPersister.getElementPersister();
        Type[] propertyTypes = elementPersister.getPropertyTypes();
        for (int index = 0; index < propertyTypes.length; ++index) {
            Type type = propertyTypes[index];
            if (!type.isAssociationType()) continue;
            boolean matching = false;
            if (collectionPersister.isOneToMany() && !type.isCollectionType()) {
                matching = this.isToOneMatching(elementPersister, index, type);
            } else if (!collectionPersister.isOneToMany() && type.isCollectionType()) {
                matching = this.isCollectionMatching((CollectionType)type, collectionPersister.getTableName());
            }
            if (!matching) continue;
            otherSidePropertyName = elementPersister.getPropertyNames()[index];
            break;
        }
        return this.processOtherSidePropertyName(otherSidePropertyName);
    }

    private boolean isToOneMatching(Loadable elementPersister, int index, Type type) {
        OneToOneType oneToOneType;
        String associatedProperty;
        if (((EntityType)type).isOneToOne() && (associatedProperty = (oneToOneType = (OneToOneType)type).getRHSUniqueKeyPropertyName()) != null) {
            OgmEntityPersister mainSidePersister = (OgmEntityPersister)oneToOneType.getAssociatedJoinable(this.session.getFactory());
            try {
                int propertyIndex = mainSidePersister.getPropertyIndex(associatedProperty);
                return mainSidePersister.getPropertyTypes()[propertyIndex] == this.propertyType;
            }
            catch (HibernateException e) {
                // empty catch block
            }
        }
        return Arrays.equals(this.associationKeyMetadata.getColumnNames(), elementPersister.getPropertyColumnNames(index));
    }

    private String processOtherSidePropertyName(String otherSidePropertyName) {
        if (otherSidePropertyName != null) {
            this.isBidirectional = Boolean.TRUE;
        } else {
            this.isBidirectional = Boolean.FALSE;
            otherSidePropertyName = this.associationKeyMetadata.getTable();
        }
        return otherSidePropertyName;
    }

    private String getUnqualifiedRole(CollectionPersister persister) {
        String entity = persister.getOwnerEntityPersister().getEntityName();
        String role = persister.getRole();
        return role.substring(entity.length() + 1);
    }

    private Object[] getKeyColumnValues() {
        if (this.columnValues == null) {
            this.columnValues = LogicalPhysicalConverterHelper.getColumnsValuesFromObjectValue(this.key, this.keyGridType, this.associationKeyMetadata.getColumnNames(), this.session);
        }
        return this.columnValues;
    }

    public Tuple createAndPutAssociationTuple(RowKey rowKey) {
        Tuple associationTuple = this.gridDialect.createTupleAssociation(this.getAssociationKey(), rowKey);
        this.getAssociation().put(rowKey, associationTuple);
        return associationTuple;
    }

    public Association getAssociation() {
        if (this.association == null) {
            AssociationKey key = this.getAssociationKey();
            if (this.isBidirectional == Boolean.FALSE) {
                this.association = new Association();
            } else {
                this.association = this.gridDialect.getAssociation(key, this.getAssociationContext());
                if (this.association == null) {
                    this.association = this.gridDialect.createAssociation(key, this.getAssociationContext());
                }
            }
        }
        return this.association;
    }

    public Association getAssociationOrNull() {
        if (this.association == null) {
            this.association = this.gridDialect.getAssociation(this.getAssociationKey(), this.getAssociationContext());
        }
        return this.association;
    }

    public void flushToCache() {
        if (this.isBidirectional != Boolean.FALSE) {
            if (this.getAssociation().isEmpty()) {
                this.gridDialect.removeAssociation(this.getAssociationKey(), this.getAssociationContext());
                this.association = null;
            } else {
                this.gridDialect.updateAssociation(this.getAssociation(), this.getAssociationKey(), this.getAssociationContext());
            }
            this.updateHostingEntityIfRequired();
        }
    }

    private void updateHostingEntityIfRequired() {
        if (this.hostingEntity != null && this.hostingEntityRequiresReadAfterUpdate()) {
            EntityPersister entityPersister = this.getHostingEntityPersister();
            entityPersister.processUpdateGeneratedProperties(entityPersister.getIdentifier(this.hostingEntity, this.session), this.hostingEntity, new Object[entityPersister.getPropertyNames().length], this.session);
        }
    }

    public boolean hostingEntityRequiresReadAfterUpdate() {
        if (this.hostingEntityRequiresReadAfterUpdate == null) {
            boolean storedInEntityStructure = this.gridDialect.isStoredInEntityStructure(this.getAssociationKey(), this.getAssociationContext());
            boolean hasUpdateGeneratedProperties = this.getHostingEntityPersister().hasUpdateGeneratedProperties();
            this.hostingEntityRequiresReadAfterUpdate = storedInEntityStructure && hasUpdateGeneratedProperties;
        }
        return this.hostingEntityRequiresReadAfterUpdate;
    }

    private EntityPersister getHostingEntityPersister() {
        if (this.hostingEntityPersister == null) {
            this.hostingEntityPersister = this.session.getFactory().getEntityPersister(this.hostingEntityType.getName());
        }
        return this.hostingEntityPersister;
    }

    public AssociationContext getAssociationContext() {
        if (this.associationContext == null) {
            OptionsService.OptionsServiceContext serviceContext = ((OptionsService)this.session.getFactory().getServiceRegistry().getService(OptionsService.class)).context();
            this.associationContext = new AssociationContext(serviceContext.getPropertyOptions(this.hostingEntityType, this.getAssociationKey().getCollectionRole()));
        }
        return this.associationContext;
    }
}

