/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.InternalSchemaActions;

public class IndexCreatorImpl
implements IndexCreator {
    private final Collection<String> propertyKeys;
    private final Label label;
    private final InternalSchemaActions actions;

    public IndexCreatorImpl(InternalSchemaActions actions, Label label) {
        this.actions = actions;
        this.label = label;
        this.propertyKeys = new ArrayList<String>();
    }

    private IndexCreatorImpl(InternalSchemaActions actions, Label label, Collection<String> propertyKeys) {
        this.actions = actions;
        this.label = label;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public IndexCreator on(String propertyKey) {
        if (!this.propertyKeys.isEmpty()) {
            throw new UnsupportedOperationException("Compound indexes are not yet supported, only one property per index is allowed.");
        }
        return new IndexCreatorImpl(this.actions, this.label, IteratorUtil.addToCollection(Arrays.asList(propertyKey), new ArrayList<String>(this.propertyKeys)));
    }

    @Override
    public IndexDefinition create() throws ConstraintViolationException {
        if (this.propertyKeys.isEmpty()) {
            throw new ConstraintViolationException("An index needs at least one property key to index");
        }
        return this.actions.createIndexDefinition(this.label, IteratorUtil.single(this.propertyKeys));
    }
}

