/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.TransactionalException;

public class TransactionFailureException
extends TransactionalException {
    private final Rethrow rethrow;

    public TransactionFailureException(HeuristicMixedException cause) {
        super((Exception)cause);
        this.rethrow = Rethrow.HEURISTIC_MIXED;
    }

    public TransactionFailureException(HeuristicRollbackException cause) {
        super((Exception)cause);
        this.rethrow = Rethrow.HEURISTIC_ROLLBACK;
    }

    public TransactionFailureException(RollbackException cause) {
        super((Exception)cause);
        this.rethrow = Rethrow.ROLLBACK;
    }

    public TransactionFailureException(SystemException cause) {
        super((Exception)cause);
        this.rethrow = Rethrow.SYSTEM;
    }

    public TransactionFailureException(RuntimeException cause) {
        super(cause);
        this.rethrow = Rethrow.RUNTIME;
    }

    public RuntimeException unBoxedForCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        return this.rethrow.exception(this.getCause());
    }

    public RuntimeException unBoxedForRollback() throws SystemException {
        return this.rethrow.exceptionForRollback(this.getCause());
    }

    private static enum Rethrow {
        HEURISTIC_MIXED(5){

            @Override
            RuntimeException exception(Throwable exception) throws HeuristicMixedException {
                throw (HeuristicMixedException)exception;
            }
        }
        ,
        HEURISTIC_ROLLBACK(6){

            @Override
            RuntimeException exception(Throwable exception) throws HeuristicRollbackException {
                throw (HeuristicRollbackException)exception;
            }
        }
        ,
        ROLLBACK(100){

            @Override
            RuntimeException exception(Throwable exception) throws RollbackException {
                throw (RollbackException)exception;
            }
        }
        ,
        SYSTEM(0){

            @Override
            RuntimeException exception(Throwable exception) throws SystemException {
                throw (SystemException)exception;
            }

            @Override
            RuntimeException exceptionForRollback(Throwable exception) throws SystemException {
                throw (SystemException)exception;
            }
        }
        ,
        RUNTIME(0){

            @Override
            RuntimeException exception(Throwable exception) {
                return (RuntimeException)exception;
            }

            @Override
            RuntimeException exceptionForRollback(Throwable exception) throws SystemException {
                return (RuntimeException)exception;
            }
        };

        int errorCodeOnRollback;

        private Rethrow(int errorCodeOnRollback) {
            this.errorCodeOnRollback = errorCodeOnRollback;
        }

        abstract RuntimeException exception(Throwable var1) throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException;

        RuntimeException exceptionForRollback(Throwable exception) throws SystemException {
            throw Exceptions.withCause(new SystemException(this.errorCodeOnRollback), exception);
        }
    }
}

