/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.operations;

import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.operations.KeyReadOperations;

public class KeyNameLookup {
    private final KeyReadOperations keyReadOperations;

    public KeyNameLookup(KeyReadOperations keyReadOperations) {
        this.keyReadOperations = keyReadOperations;
    }

    public String getLabelName(long labelId) {
        try {
            return this.keyReadOperations.labelGetName(labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    public String getPropertyKeyName(long propertyId) {
        try {
            return this.keyReadOperations.propertyKeyGetName(propertyId);
        }
        catch (PropertyKeyIdNotFoundException e) {
            return "[" + propertyId + "]";
        }
    }
}

