/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.PropertyWithValue;

final class CharProperty
extends PropertyWithValue {
    private final char value;
    private final long propertyKeyId;

    CharProperty(long propertyKeyId, char value) {
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public Character value() {
        return Character.valueOf(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharProperty) {
            CharProperty that = (CharProperty)o;
            return this.propertyKeyId == that.propertyKeyId && this.value == that.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.value;
        result = 31 * result + (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
        return result;
    }
}

