/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.ConstraintCreationException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.CachingStatementContext;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.DelegatingTransactionContext;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StateHandlingStatementContext;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.constraints.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class StateHandlingTransactionContext
extends DelegatingTransactionContext {
    private final SchemaIndexProviderMap providerMap;
    private final PersistenceCache persistenceCache;
    private final TxState state;
    private final SchemaCache schemaCache;
    private final PersistenceManager persistenceManager;
    private final SchemaStorage schemaStorage;
    private final UpdateableSchemaState schemaState;
    private final ConstraintIndexCreator constraintIndexCreator;

    public StateHandlingTransactionContext(TransactionContext actual, SchemaStorage schemaStorage, TxState state, SchemaIndexProviderMap providerMap, PersistenceCache persistenceCache, SchemaCache schemaCache, PersistenceManager persistenceManager, UpdateableSchemaState schemaState, ConstraintIndexCreator constraintIndexCreator) {
        super(actual);
        this.schemaStorage = schemaStorage;
        this.providerMap = providerMap;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.persistenceManager = persistenceManager;
        this.schemaState = schemaState;
        this.state = state;
        this.constraintIndexCreator = constraintIndexCreator;
    }

    @Override
    public StatementContext newStatementContext() {
        StatementContext result = super.newStatementContext();
        result = new CachingStatementContext(result, this.persistenceCache, this.schemaCache);
        result = new StateHandlingStatementContext(result, new SchemaStateConcern(this.schemaState), this.state, this.constraintIndexCreator);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionFailureException {
        boolean success = false;
        try {
            this.createTransactionCommands();
            super.commit();
            success = true;
        }
        finally {
            if (!success) {
                this.dropCreatedConstraintIndexes();
            }
        }
        this.persistenceCache.apply(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws TransactionFailureException {
        try {
            this.dropCreatedConstraintIndexes();
        }
        finally {
            super.rollback();
        }
    }

    private void createTransactionCommands() {
        final AtomicBoolean clearState = new AtomicBoolean(false);
        this.state.accept(new TxState.Visitor(){

            @Override
            public void visitNodeLabelChanges(long id, Set<Long> added, Set<Long> removed) {
            }

            @Override
            public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                SchemaIndexProvider.Descriptor providerDescriptor = StateHandlingTransactionContext.this.providerMap.getDefaultProvider().getProviderDescriptor();
                IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(StateHandlingTransactionContext.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(StateHandlingTransactionContext.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
                StateHandlingTransactionContext.this.persistenceManager.createSchemaRule(rule);
            }

            @Override
            public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
                try {
                    IndexRule rule = StateHandlingTransactionContext.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId());
                    StateHandlingTransactionContext.this.persistenceManager.dropSchemaRule(rule.getId());
                }
                catch (SchemaRuleNotFoundException e) {
                    throw new ThisShouldNotHappenError("Tobias Lindaaker", "Index to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                }
            }

            @Override
            public void visitAddedConstraint(UniquenessConstraint element, long indexId) {
                try {
                    StateHandlingTransactionContext.this.constraintIndexCreator.validateConstraintIndex(element, indexId);
                }
                catch (ConstraintCreationKernelException e) {
                    throw new ConstraintCreationException(e);
                }
                clearState.set(true);
                long constraintId = StateHandlingTransactionContext.this.schemaStorage.newRuleId();
                StateHandlingTransactionContext.this.persistenceManager.createSchemaRule(UniquenessConstraintRule.uniquenessConstraintRule(constraintId, element.label(), element.property(), indexId));
                StateHandlingTransactionContext.this.persistenceManager.setConstraintIndexOwner(indexId, constraintId);
            }

            @Override
            public void visitRemovedConstraint(UniquenessConstraint element) {
                try {
                    clearState.set(true);
                    UniquenessConstraintRule rule = StateHandlingTransactionContext.this.schemaStorage.uniquenessConstraint(element.label(), element.property());
                    StateHandlingTransactionContext.this.persistenceManager.dropSchemaRule(rule.getId());
                }
                catch (SchemaRuleNotFoundException e) {
                    throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
                }
                this.visitRemovedIndex(new IndexDescriptor(element.label(), element.property()), true);
            }
        });
        if (clearState.get()) {
            this.schemaState.clear();
        }
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        for (IndexDescriptor createdConstraintIndex : this.state.createdConstraintIndexes()) {
            try {
                this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
            }
            catch (SchemaKernelException e) {
                throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
            }
            catch (TransactionFailureException e) {
                throw e;
            }
            catch (TransactionalException e) {
                throw new IllegalStateException("The transaction manager could not fulfill the transaction for dropping the constraint.", e);
            }
        }
    }
}

