/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.StoreStatementContext;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class StoreTransactionContext
implements TransactionContext {
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final AbstractTransactionManager transactionManager;
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final LabelTokenHolder labelTokenHolder;
    private final NodeManager nodeManager;

    public StoreTransactionContext(AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, NodeManager nodeManager, NeoStore neoStore, IndexingService indexingService) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.transactionManager = transactionManager;
        this.nodeManager = nodeManager;
        this.neoStore = neoStore;
        this.indexingService = indexingService;
    }

    @Override
    public StatementContext newStatementContext() {
        return new StoreStatementContext(this.propertyKeyTokenHolder, this.labelTokenHolder, this.nodeManager, new SchemaStorage(this.neoStore.getSchemaStore()), this.neoStore, this.indexingService, new IndexReaderFactory.Caching(this.indexingService));
    }

    @Override
    public void prepare() {
    }

    @Override
    public void commit() throws TransactionFailureException {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException e) {
            throw new TransactionFailureException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionFailureException(e);
        }
        catch (RollbackException e) {
            throw new TransactionFailureException(e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException(e);
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException(e);
        }
    }

    @Override
    public void rollback() throws TransactionFailureException {
        try {
            if (this.transactionManager.getTransaction() != null) {
                this.transactionManager.rollback();
            }
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException(e);
        }
        catch (SecurityException e) {
            throw new TransactionFailureException(e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException(e);
        }
    }
}

