/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.AbstractSwallowingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailedKernelException;

public class FailedIndexProxy
extends AbstractSwallowingIndexProxy {
    protected final IndexPopulator populator;

    public FailedIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulator populator) {
        this(descriptor, providerDescriptor, populator, null);
    }

    public FailedIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulator populator, Throwable cause) {
        super(descriptor, providerDescriptor, cause);
        this.populator = populator;
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.populator.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.FAILED;
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException {
        throw new IndexPopulationFailedKernelException(this.getDescriptor(), this.getCause());
    }

    @Override
    public void activate() {
        throw new UnsupportedOperationException("Cannot activate a failed index.");
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        throw new IndexPopulationFailedKernelException(this.getDescriptor(), this.getCause());
    }
}

