/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class RemoveOrphanConstraintIndexesOnStartup {
    private final AbstractTransactionManager txManager;
    private final StringLogger log;

    public RemoveOrphanConstraintIndexesOnStartup(AbstractTransactionManager txManager, Logging logging) {
        this.txManager = txManager;
        this.log = logging.getMessagesLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        try {
            this.txManager.begin(ForceMode.unforced);
            TransactionContext tx = this.txManager.getTransactionContext();
            boolean success = false;
            try {
                StatementContext context = tx.newStatementContext();
                try {
                    Iterator<IndexDescriptor> indexes = context.uniqueIndexesGetAll();
                    while (indexes.hasNext()) {
                        IndexDescriptor index = indexes.next();
                        if (context.indexGetOwningUniquenessConstraintId(index) != null) continue;
                        context.uniqueIndexDrop(index);
                    }
                }
                finally {
                    context.close();
                }
                success = true;
            }
            finally {
                if (success) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
        }
        catch (Throwable e) {
            this.log.error("Failed to execute orphan index checking transaction.", e);
        }
    }
}

