/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.DelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public class RuleUpdateFilterIndexProxy
extends DelegatingIndexProxy {
    private final Predicate<NodePropertyUpdate> ruleMatchingUpdates = new Predicate<NodePropertyUpdate>(){

        @Override
        public boolean accept(NodePropertyUpdate item) {
            IndexDescriptor descriptor = RuleUpdateFilterIndexProxy.this.getDescriptor();
            return item.getPropertyKeyId() == descriptor.getPropertyKeyId() && item.forLabel(descriptor.getLabelId());
        }
    };

    public RuleUpdateFilterIndexProxy(IndexProxy delegate) {
        super(delegate);
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        super.update(new FilteringIterable<NodePropertyUpdate>(updates, this.ruleMatchingUpdates));
    }
}

