/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.constraints.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;

public class TentativeConstraintIndexProxy
extends AbstractDelegatingIndexProxy {
    private final FlippableIndexProxy flipper;
    private final OnlineIndexProxy target;
    private final Collection<IndexEntryConflictException> failures = new CopyOnWriteArrayList<IndexEntryConflictException>();

    public TentativeConstraintIndexProxy(FlippableIndexProxy flipper, OnlineIndexProxy target) {
        this.flipper = flipper;
        this.target = target;
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        try {
            this.target.accessor.updateAndCommit(updates);
        }
        catch (IndexEntryConflictException conflict) {
            this.failures.add(conflict);
        }
    }

    @Override
    public InternalIndexState getState() {
        return this.failures.isEmpty() ? InternalIndexState.POPULATING : InternalIndexState.FAILED;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[target:" + this.target + "]";
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException(this.getDescriptor() + " is still populating");
    }

    @Override
    protected IndexProxy getDelegate() {
        return this.target;
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        Iterator<IndexEntryConflictException> iterator = this.failures.iterator();
        if (iterator.hasNext()) {
            HashSet<ConstraintVerificationFailedKernelException.Evidence> evidence = new HashSet<ConstraintVerificationFailedKernelException.Evidence>();
            do {
                evidence.add(new ConstraintVerificationFailedKernelException.Evidence(iterator.next()));
            } while (iterator.hasNext());
            IndexDescriptor descriptor = this.getDescriptor();
            throw new IndexPopulationFailedKernelException(descriptor, (Throwable)new ConstraintVerificationFailedKernelException(new UniquenessConstraint(descriptor.getLabelId(), descriptor.getPropertyKeyId()), evidence));
        }
    }

    @Override
    public void activate() {
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to activate failed index, should have checked the failures earlier...");
        }
        this.flipper.flipTo(this.target);
    }
}

