/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyEventData;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public abstract class Primitive {
    protected static final PropertyData[] NO_PROPERTIES = new PropertyData[0];

    protected abstract PropertyData changeProperty(NodeManager var1, PropertyData var2, Object var3, TransactionState var4);

    protected abstract PropertyData addProperty(NodeManager var1, Token var2, Object var3);

    protected abstract void removeProperty(NodeManager var1, PropertyData var2, TransactionState var3);

    protected abstract ArrayMap<Integer, PropertyData> loadProperties(NodeManager var1, boolean var2);

    Primitive(boolean newPrimitive) {
        if (newPrimitive) {
            this.setEmptyProperties();
        }
    }

    public abstract long getId();

    protected abstract void setEmptyProperties();

    protected abstract PropertyData[] allProperties();

    protected abstract PropertyData getPropertyForIndex(int var1);

    protected abstract void setProperties(ArrayMap<Integer, PropertyData> var1, NodeManager var2);

    protected abstract void commitPropertyMaps(ArrayMap<Integer, PropertyData> var1, ArrayMap<Integer, PropertyData> var2, long var3, NodeManager var5);

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public abstract boolean equals(Object var1);

    public Iterable<Object> getPropertyValues(NodeManager nodeManager) {
        TransactionState tx = nodeManager.getTransactionState();
        ArrayMap<Integer, PropertyData> skipMap = null;
        ArrayMap<Integer, PropertyData> addMap = null;
        if (tx.hasChanges()) {
            skipMap = tx.getCowPropertyRemoveMap(this);
            addMap = tx.getCowPropertyAddMap(this);
        }
        this.ensureFullProperties(nodeManager);
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyData property : this.allProperties()) {
            Integer index = property.getIndex();
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            values.add(this.getPropertyValue(nodeManager, property));
        }
        if (addMap != null) {
            for (PropertyData property : addMap.values()) {
                values.add(this.getPropertyValue(nodeManager, property));
            }
        }
        return values;
    }

    public Iterable<String> getPropertyKeys(NodeManager nodeManager) {
        TransactionState tx = nodeManager.getTransactionState();
        ArrayMap<Integer, PropertyData> skipMap = null;
        ArrayMap<Integer, PropertyData> addMap = null;
        if (tx.hasChanges()) {
            skipMap = tx.getCowPropertyRemoveMap(this);
            addMap = tx.getCowPropertyAddMap(this);
        }
        this.ensureFullProperties(nodeManager);
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (PropertyData property : this.allProperties()) {
                Integer index = property.getIndex();
                if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
                keys.add(nodeManager.getPropertyKeyToken(index).name());
            }
            if (addMap != null) {
                for (Integer index : addMap.keySet()) {
                    keys.add(nodeManager.getPropertyKeyToken(index).name());
                }
            }
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
        return keys;
    }

    public Object getProperty(NodeManager nodeManager, String key) throws NotFoundException {
        Token token = nodeManager.getPropertyKeyTokenOrNull(key);
        if (token != null) {
            return this.getProperty(nodeManager, token.id());
        }
        throw this.newPropertyNotFoundException(key);
    }

    public Object getProperty(NodeManager nodeManager, int key) throws NotFoundException {
        PropertyData property;
        TransactionState tx = nodeManager.getTransactionState();
        ArrayMap<Integer, PropertyData> skipMap = null;
        ArrayMap<Integer, PropertyData> addMap = null;
        if (tx.hasChanges()) {
            skipMap = tx.getCowPropertyRemoveMap(this);
            addMap = tx.getCowPropertyAddMap(this);
        }
        this.ensureFullProperties(nodeManager);
        if (skipMap != null && skipMap.get(key) != null) {
            throw this.newPropertyNotFoundException("No property with id " + key + " exists on " + this);
        }
        if (addMap != null && (property = addMap.get(key)) != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        property = this.getPropertyForIndex(key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        throw this.newPropertyNotFoundException("No property with id " + key + " exists on " + this);
    }

    private NotFoundException newPropertyNotFoundException(String key) {
        return new NotFoundException("'" + key + "' property not found for " + this + ".");
    }

    public Object getProperty(NodeManager nodeManager, String key, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        TransactionState tx = nodeManager.getTransactionState();
        ArrayMap<Integer, PropertyData> skipMap = null;
        ArrayMap<Integer, PropertyData> addMap = null;
        if (tx.hasChanges()) {
            skipMap = tx.getCowPropertyRemoveMap(this);
            addMap = tx.getCowPropertyAddMap(this);
        }
        this.ensureFullProperties(nodeManager);
        Token index = nodeManager.getPropertyKeyTokenOrNull(key);
        if (index != null) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.id()) != null) {
                return defaultValue;
            }
            if (addMap != null && (property = addMap.get(index.id())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.getPropertyForIndex(index.id());
            if (property != null) {
                return this.getPropertyValue(nodeManager, property);
            }
        }
        return defaultValue;
    }

    public boolean hasProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            return false;
        }
        TransactionState tx = nodeManager.getTransactionState();
        ArrayMap<Integer, PropertyData> skipMap = null;
        ArrayMap<Integer, PropertyData> addMap = null;
        if (tx.hasChanges()) {
            skipMap = tx.getCowPropertyRemoveMap(this);
            addMap = tx.getCowPropertyAddMap(this);
        }
        this.ensureFullProperties(nodeManager);
        Token index = nodeManager.getPropertyKeyTokenOrNull(key);
        if (index != null) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.id()) != null) {
                return false;
            }
            if (addMap != null && (property = addMap.get(index.id())) != null) {
                return true;
            }
            property = this.getPropertyForIndex(index.id());
            if (property != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(NodeManager nodeManager, PropertyContainer proxy, String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null parameter, key=" + key + ", " + "value=" + value);
        }
        TransactionState tx = nodeManager.getTransactionState();
        tx.acquireWriteLock(proxy);
        boolean success = false;
        try {
            this.ensureFullProperties(nodeManager);
            ArrayMap<Integer, PropertyData> addMap = tx.getOrCreateCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> skipMap = tx.getCowPropertyRemoveMap(this);
            Token index = null;
            PropertyData property = null;
            boolean foundInSkipMap = false;
            Token cachedIndex = nodeManager.getPropertyKeyTokenOrNull(key);
            if (cachedIndex != null) {
                if (skipMap != null && skipMap.remove(cachedIndex.id()) != null) {
                    foundInSkipMap = true;
                }
                index = cachedIndex;
                property = addMap.get(cachedIndex.id());
                if (property == null) {
                    property = this.getPropertyForIndex(cachedIndex.id());
                }
            }
            if (index == null) {
                int keyId = nodeManager.getOrCreatePropertyKeyId(key);
                index = nodeManager.getPropertyKeyTokenOrNull(keyId);
            }
            property = property != null && !foundInSkipMap ? this.changeProperty(nodeManager, property, value, tx) : this.addProperty(nodeManager, index, value);
            addMap.put(index.id(), property);
            success = true;
        }
        finally {
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(NodeManager nodeManager, PropertyContainer proxy, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        boolean success = false;
        TransactionState tx = nodeManager.getTransactionState();
        tx.acquireWriteLock(proxy);
        try {
            this.ensureFullProperties(nodeManager);
            PropertyData property = this.getAndUpdateTransactionStateForRemoveProperty(nodeManager, tx, key);
            if (property == null) {
                success = true;
                Object var7_7 = null;
                return var7_7;
            }
            this.removeProperty(nodeManager, property, tx);
            success = true;
            Object object = this.getPropertyValue(nodeManager, property);
            return object;
        }
        finally {
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    private PropertyData getAndUpdateTransactionStateForRemoveProperty(NodeManager nodeManager, TransactionState tx, String key) {
        ArrayMap<Integer, PropertyData> addMap = tx.getCowPropertyAddMap(this);
        ArrayMap<Integer, PropertyData> removeMap = tx.getCowPropertyRemoveMap(this);
        Token cachedIndex = nodeManager.getPropertyKeyTokenOrNull(key);
        PropertyData property = null;
        if (cachedIndex != null) {
            if (addMap != null && (property = addMap.remove(cachedIndex.id())) != null) {
                removeMap = removeMap != null ? removeMap : tx.getOrCreateCowPropertyRemoveMap(this);
                removeMap.put(cachedIndex.id(), property);
                return property;
            }
            if (removeMap != null && removeMap.get(cachedIndex.id()) != null) {
                return null;
            }
            property = this.getPropertyForIndex(cachedIndex.id());
            if (property != null) {
                removeMap = removeMap != null ? removeMap : tx.getOrCreateCowPropertyRemoveMap(this);
                removeMap.put(cachedIndex.id(), property);
            }
        }
        return property;
    }

    private Object getPropertyValue(NodeManager nodeManager, PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = nodeManager.loadPropertyValue(property);
            property.setNewValue(value);
        }
        return value;
    }

    private void ensureFullProperties(NodeManager nodeManager) {
        this.ensureFullProperties(nodeManager, false);
    }

    private void ensureFullLightProperties(NodeManager nodeManager) {
        this.ensureFullProperties(nodeManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFullProperties(NodeManager nodeManager, boolean light) {
        if (this.allProperties() == null) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (this.allProperties() == null) {
                    try {
                        ArrayMap<Integer, PropertyData> loadedProperties = this.loadProperties(nodeManager, light);
                        this.setProperties(loadedProperties, nodeManager);
                    }
                    catch (InvalidRecordException e) {
                        throw new NotFoundException(this.asProxy(nodeManager) + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
    }

    protected List<PropertyEventData> getAllCommittedProperties(NodeManager nodeManager) {
        this.ensureFullLightProperties(nodeManager);
        if (this.allProperties() == null) {
            return new ArrayList<PropertyEventData>();
        }
        PropertyData[] properties = this.allProperties();
        ArrayList<PropertyEventData> props = new ArrayList<PropertyEventData>(properties.length);
        for (PropertyData property : properties) {
            Token index = nodeManager.getPropertyKeyTokenOrNull(property.getIndex());
            Object value = this.getPropertyValue(nodeManager, property);
            props.add(new PropertyEventData(index.name(), value));
        }
        return props;
    }

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        PropertyData property;
        this.ensureFullLightProperties(nodeManager);
        Token index = nodeManager.getPropertyKeyTokenOrNull(key);
        if (index != null && (property = this.getPropertyForIndex(index.id())) != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        return null;
    }

    public abstract WritableTransactionState.CowEntityElement getEntityElement(WritableTransactionState.PrimitiveElement var1, boolean var2);

    abstract PropertyContainer asProxy(NodeManager var1);
}

