/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.core.PropertyEntryImpl;

class TransactionDataImpl
implements TransactionData {
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = this.newCollection();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = this.newCollection();
    private final Collection<Node> createdNodes = this.newCollection();
    private final Collection<Relationship> createdRelationships = this.newCollection();
    private final Collection<Node> deletedNodes = new HashSet<Node>();
    private final Collection<Relationship> deletedRelationships = new HashSet<Relationship>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = this.newCollection();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = this.newCollection();

    TransactionDataImpl() {
    }

    private <T> Collection<T> newCollection() {
        return new ArrayList();
    }

    @Override
    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    @Override
    public Iterable<Node> createdNodes() {
        return this.createdNodes;
    }

    @Override
    public Iterable<Relationship> createdRelationships() {
        return this.createdRelationships;
    }

    @Override
    public Iterable<Node> deletedNodes() {
        return this.deletedNodes;
    }

    @Override
    public boolean isDeleted(Node node) {
        return this.deletedNodes.contains(node);
    }

    @Override
    public Iterable<Relationship> deletedRelationships() {
        return this.deletedRelationships;
    }

    @Override
    public boolean isDeleted(Relationship relationship) {
        return this.deletedRelationships.contains(relationship);
    }

    @Override
    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    void assignedProperty(Node node, String key, Object value, Object valueBeforeTransaction) {
        this.assignedNodeProperties.add(PropertyEntryImpl.assigned(node, key, value, valueBeforeTransaction));
    }

    void assignedProperty(Relationship relationship, String key, Object value, Object valueBeforeTransaction) {
        this.assignedRelationshipProperties.add(PropertyEntryImpl.assigned(relationship, key, value, valueBeforeTransaction));
    }

    void removedProperty(Node node, String key, Object valueBeforeTransaction) {
        this.removedNodeProperties.add(PropertyEntryImpl.removed(node, key, valueBeforeTransaction));
    }

    void removedProperty(Relationship relationship, String key, Object valueBeforeTransaction) {
        this.removedRelationshipProperties.add(PropertyEntryImpl.removed(relationship, key, valueBeforeTransaction));
    }

    void created(Node node) {
        this.createdNodes.add(node);
    }

    void created(Relationship relationship) {
        this.createdRelationships.add(relationship);
    }

    void deleted(Node node) {
        this.deletedNodes.add(node);
    }

    void deleted(Relationship relationship) {
        this.deletedRelationships.add(relationship);
    }
}

