/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class NioNeoDbPersistenceSource
implements PersistenceSource,
EntityIdGenerator,
Lifecycle {
    private String dataSourceName = null;
    private XaDataSourceManager xaDataSourceManager;

    public NioNeoDbPersistenceSource(XaDataSourceManager xaDataSourceManager) {
        assert (xaDataSourceManager != null);
        this.xaDataSourceManager = xaDataSourceManager;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public NeoStoreTransaction createTransaction(XaConnection connection) {
        if (this.xaDataSourceManager.getNeoStoreDataSource().isReadOnly()) {
            throw new ReadOnlyDbException();
        }
        WriteTransaction result = ((NeoStoreXaConnection)connection).getWriteTransaction();
        result.setXaConnection(connection);
        return result;
    }

    public NeoStoreTransaction createReadOnlyResourceConnection() {
        return new ReadTransaction(this.xaDataSourceManager.getNeoStoreDataSource().getNeoStore());
    }

    public String toString() {
        return "A persistence source to [" + this.dataSourceName + "]";
    }

    @Override
    public long nextId(Class<?> clazz) {
        return this.xaDataSourceManager.getNeoStoreDataSource().nextId(clazz);
    }

    @Override
    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.xaDataSourceManager.getNeoStoreDataSource().getHighestPossibleIdInUse(clazz);
    }

    @Override
    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.xaDataSourceManager.getNeoStoreDataSource().getNumberOfIdsInUse(clazz);
    }

    @Override
    public XaDataSource getXaDataSource() {
        return this.xaDataSourceManager.getNeoStoreDataSource();
    }
}

