/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyPropertyStoreReader
implements Closeable {
    public static final String FROM_VERSION = "PropertyStore v0.A.0";
    public static final int RECORD_SIZE = 41;
    private final FileChannel fileChannel;
    private final long maxId;

    public LegacyPropertyStoreReader(FileSystemAbstraction fs, File file) throws IOException {
        this.fileChannel = fs.open(file, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 41L;
    }

    public Iterator<PropertyRecord> readPropertyStore() throws IOException {
        return new PrefetchingIterator<PropertyRecord>(){
            private long id = -1L;
            ByteBuffer buffer = ByteBuffer.allocateDirect(41);

            @Override
            protected PropertyRecord fetchNextOrNull() {
                while (++this.id <= LegacyPropertyStoreReader.this.maxId) {
                    LegacyStore.readIntoBuffer(LegacyPropertyStoreReader.this.fileChannel, this.buffer, 41);
                    PropertyRecord record = LegacyPropertyStoreReader.this.readPropertyRecord(this.id, this.buffer);
                    if (!record.inUse()) continue;
                    return record;
                }
                return null;
            }
        };
    }

    protected PropertyRecord readPropertyRecord(long id, ByteBuffer buffer) {
        PropertyBlock newBlock;
        PropertyRecord record = new PropertyRecord(id);
        byte modifiers = buffer.get();
        long prevMod = ((long)modifiers & 0xF0L) << 28;
        long nextMod = ((long)modifiers & 0xFL) << 32;
        long prevProp = LegacyStore.getUnsignedInt(buffer);
        long nextProp = LegacyStore.getUnsignedInt(buffer);
        record.setPrevProp(LegacyStore.longFromIntAndMod(prevProp, prevMod));
        record.setNextProp(LegacyStore.longFromIntAndMod(nextProp, nextMod));
        while (buffer.hasRemaining() && (newBlock = this.getPropertyBlock(buffer)) != null) {
            record.addPropertyBlock(newBlock);
            record.setInUse(true);
        }
        return record;
    }

    private PropertyBlock getPropertyBlock(ByteBuffer buffer) {
        long header = buffer.getLong();
        PropertyType type = PropertyType.getPropertyType(header, true);
        if (type == null) {
            return null;
        }
        PropertyBlock toReturn = new PropertyBlock();
        int numBlocks = type.calculateNumberOfBlocksUsed(header);
        long[] blockData = new long[numBlocks];
        blockData[0] = header;
        for (int i = 1; i < numBlocks; ++i) {
            blockData[i] = buffer.getLong();
        }
        toReturn.setValueBlocks(blockData);
        return toReturn;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

