/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ArrayIntSet {
    private int maxRelSize = 256;
    private int[] rels = new int[2];
    private int arrayCount = 0;
    private Set<Integer> relationshipSet = null;

    public boolean add(int id) {
        int i;
        for (i = 0; i < this.arrayCount; ++i) {
            if (this.rels[i] != id) continue;
            return false;
        }
        if (this.arrayCount == this.rels.length && this.rels.length * 2 <= this.maxRelSize) {
            int[] newRels = new int[this.rels.length * 2];
            System.arraycopy(this.rels, 0, newRels, 0, this.rels.length);
            this.rels = newRels;
        }
        if (this.arrayCount != -1) {
            if (this.arrayCount < this.rels.length) {
                this.rels[this.arrayCount++] = id;
                return true;
            }
            this.relationshipSet = new HashSet<Integer>();
            for (i = 0; i < this.arrayCount; ++i) {
                this.relationshipSet.add(this.rels[i]);
            }
            this.arrayCount = -1;
        }
        return this.relationshipSet.add(id);
    }

    public Iterator<Integer> iterator() {
        if (this.arrayCount == -1) {
            return this.relationshipSet.iterator();
        }
        return new ArrayIntIterator(this.rels, this.arrayCount);
    }

    public boolean remove(int id) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (this.rels[i] != id) continue;
            int[] dest = this.rels;
            if (this.arrayCount - 1 < this.rels.length / 3) {
                dest = new int[this.rels.length / 2];
                System.arraycopy(this.rels, 0, dest, 0, this.arrayCount);
            }
            if (i + 1 < dest.length && this.arrayCount - i - 1 > 0) {
                System.arraycopy(this.rels, i + 1, dest, i, this.arrayCount - i - 1);
                this.rels = dest;
            }
            --this.arrayCount;
            return true;
        }
        if (this.arrayCount == -1) {
            return this.relationshipSet.remove(id);
        }
        return false;
    }

    public Iterable<Integer> values() {
        if (this.arrayCount == -1) {
            return this.relationshipSet;
        }
        return new ArrayIntIterator(this.rels, this.arrayCount);
    }

    public boolean contains(int id) {
        for (int i = 0; i < this.arrayCount; ++i) {
            if (this.rels[i] != id) continue;
            return true;
        }
        if (this.arrayCount == -1) {
            return this.relationshipSet.contains(id);
        }
        return false;
    }

    public int size() {
        if (this.arrayCount != -1) {
            return this.arrayCount;
        }
        return this.relationshipSet.size();
    }

    private static class ArrayIntIterator
    implements Iterator<Integer>,
    Iterable<Integer> {
        private int[] intArray;
        private int pos = -1;
        private int arrayCount;

        ArrayIntIterator(int[] array, int count) {
            this.intArray = array;
            this.arrayCount = count;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < this.arrayCount;
        }

        @Override
        public Integer next() {
            return this.intArray[++this.pos];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }
    }
}

