/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.factory.SettingsResourceBundle;

public class GenerateDefaultNeo4jProperties {
    public static void main(String[] args) throws ClassNotFoundException {
        for (String settingsClassName : args) {
            Class<?> settingsClass = GenerateDefaultNeo4jProperties.class.getClassLoader().loadClass(settingsClassName);
            SettingsResourceBundle bundle = new SettingsResourceBundle(settingsClass);
            if (bundle.containsKey("description")) {
                System.out.println("# ");
                System.out.println("# " + bundle.getString("description"));
                System.out.println("# ");
                System.out.println();
            }
            Set<String> keys = ((ResourceBundle)bundle).keySet();
            for (String property : keys) {
                String defaultKey;
                if (!property.endsWith(".description")) continue;
                String name = property.substring(0, property.lastIndexOf("."));
                System.out.println("# " + bundle.getString(property));
                String optionsKey = name + ".options";
                if (bundle.containsKey(optionsKey)) {
                    String[] options = bundle.getString(optionsKey).split(",");
                    if (bundle.containsKey(name + ".option." + options[0])) {
                        System.out.println("# Valid settings:");
                        for (String option : options) {
                            String description = bundle.getString(name + ".option." + option);
                            char[] spaces = new char[option.length() + 3];
                            Arrays.fill(spaces, ' ');
                            description = description.replace("\n", "\n#" + new String(spaces));
                            System.out.println("# " + option + ": " + description);
                        }
                    } else {
                        System.out.println("# Valid settings:" + bundle.getString(optionsKey));
                    }
                }
                if (bundle.containsKey(defaultKey = name + ".default")) {
                    System.out.println(name + "=" + bundle.getString(defaultKey));
                } else {
                    System.out.println("# " + name + "=");
                }
                System.out.println();
            }
        }
    }
}

