/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.grid.impl.RowKeyBuilder;

public class CouchDBAssociationSnapshot
implements AssociationSnapshot {
    private final CouchDBAssociation couchDbAssociation;
    private final AssociationKey key;
    private final Map<RowKey, Map<String, Object>> rows = new HashMap<RowKey, Map<String, Object>>();

    public CouchDBAssociationSnapshot(CouchDBAssociation association, AssociationKey key) {
        this.couchDbAssociation = association;
        this.key = key;
        for (Map<String, Object> row : association.getRows()) {
            RowKey rowKey = new RowKeyBuilder().tableName(key.getTable()).addColumns(key.getRowKeyColumnNames()).values(CouchDBAssociationSnapshot.getRowKeyColumnValues(row, key)).build();
            this.rows.put(rowKey, row);
        }
    }

    private static Map<String, Object> getRowKeyColumnValues(Map<String, Object> row, AssociationKey key) {
        HashMap<String, Object> rowKeyColumnValues = new HashMap<String, Object>();
        for (String rowKeyColumnName : key.getRowKeyColumnNames()) {
            rowKeyColumnValues.put(rowKeyColumnName, key.isKeyColumn(rowKeyColumnName) ? key.getColumnValue(rowKeyColumnName) : row.get(rowKeyColumnName));
        }
        return rowKeyColumnValues;
    }

    public boolean containsKey(RowKey column) {
        return this.rows.containsKey(column);
    }

    public Tuple get(RowKey column) {
        Map<String, Object> row = this.rows.get(column);
        return row != null ? new Tuple((TupleSnapshot)new CouchDBAssociationRowTupleSnapshot(row, this.key)) : null;
    }

    public int size() {
        return this.rows.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.rows.keySet();
    }

    public CouchDBAssociation getCouchDbAssociation() {
        return this.couchDbAssociation;
    }

    public String toString() {
        return "CouchDBAssociationSnapshot [key=" + this.key + ", rows=" + this.rows + "]";
    }

    private static class CouchDBAssociationRowTupleSnapshot
    implements TupleSnapshot {
        private final Map<String, Object> associationRow;
        private final AssociationKey associationKey;
        private final Set<String> columnNames;

        private CouchDBAssociationRowTupleSnapshot(Map<String, Object> associationRow, AssociationKey associationKey) {
            this.associationRow = associationRow;
            this.associationKey = associationKey;
            this.columnNames = CouchDBAssociationRowTupleSnapshot.getColumnNames(associationRow, associationKey);
        }

        private static Set<String> getColumnNames(Map<String, Object> associationRow, AssociationKey associationKey) {
            HashSet<String> columnNames = new HashSet<String>(associationRow.size() + associationKey.getColumnNames().length);
            columnNames.addAll(associationRow.keySet());
            for (String column : associationKey.getColumnNames()) {
                columnNames.add(column);
            }
            return columnNames;
        }

        public Object get(String column) {
            return this.associationKey.isKeyColumn(column) ? this.associationKey.getColumnValue(column) : this.associationRow.get(column);
        }

        public boolean isEmpty() {
            return this.columnNames.isEmpty();
        }

        public Set<String> getColumnNames() {
            return this.columnNames;
        }
    }
}

