/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.impl.FullTextQueryImpl;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FullTextEntityManagerImpl
implements FullTextEntityManager,
Serializable {
    private static final Log log = LoggerFactory.make();
    private final EntityManager em;
    private FullTextSession ftSession;

    public FullTextEntityManagerImpl(EntityManager em) {
        if (em == null) {
            throw log.getNullSessionPassedToFullEntityManagerCreationException();
        }
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FullTextSession getFullTextSession() {
        if (this.ftSession != null) return this.ftSession;
        Object delegate = this.em.getDelegate();
        if (delegate == null) {
            throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager (no delegate)");
        }
        if (Session.class.isAssignableFrom(delegate.getClass())) {
            this.ftSession = Search.getFullTextSession((Session)delegate);
            return this.ftSession;
        } else {
            if (!EntityManager.class.isAssignableFrom(delegate.getClass())) throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager: " + delegate.getClass());
            if ((delegate = ((EntityManager)delegate).getDelegate()) == null) {
                throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager (no delegate)");
            }
            if (!Session.class.isAssignableFrom(delegate.getClass())) throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager: " + delegate.getClass());
            this.ftSession = Search.getFullTextSession((Session)delegate);
        }
        return this.ftSession;
    }

    @Override
    public FullTextQuery createFullTextQuery(org.apache.lucene.search.Query luceneQuery, Class<?> ... entities) {
        FullTextSession ftSession = this.getFullTextSession();
        return new FullTextQueryImpl(ftSession.createFullTextQuery(luceneQuery, entities), ftSession);
    }

    @Override
    public <T> void index(T entity) {
        this.getFullTextSession().index(entity);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.getFullTextSession().getSearchFactory();
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        this.getFullTextSession().purge(entityType, id);
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.getFullTextSession().purgeAll(entityType);
    }

    @Override
    public void flushToIndexes() {
        this.getFullTextSession().flushToIndexes();
    }

    public void persist(Object entity) {
        this.em.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.em.merge(entity);
    }

    public void remove(Object entity) {
        this.em.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> hints) {
        return (T)this.em.find(entityClass, primaryKey, hints);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType) {
        return (T)this.em.find(entityClass, primaryKey, lockModeType);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> hints) {
        return (T)this.em.find(entityClass, primaryKey, lockModeType, hints);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.em.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.em.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.em.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.em.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> hints) {
        this.em.lock(entity, lockModeType, hints);
    }

    public void refresh(Object entity) {
        this.em.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> hints) {
        this.em.refresh(entity, hints);
    }

    public void refresh(Object entity, LockModeType lockModeType) {
        this.em.refresh(entity, lockModeType);
    }

    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> hints) {
        this.em.refresh(entity, lockModeType, hints);
    }

    public void clear() {
        this.em.clear();
    }

    public void detach(Object entity) {
        this.em.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.em.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.em.getLockMode(entity);
    }

    public void setProperty(String key, Object value) {
        this.em.setProperty(key, value);
    }

    public Map<String, Object> getProperties() {
        return this.em.getProperties();
    }

    public Query createQuery(String ejbqlString) {
        return this.em.createQuery(ejbqlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.em.createQuery(criteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.em.createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        return this.em.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.em.createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.em.createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        this.em.joinTransaction();
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(FullTextSession.class)) {
            FullTextSession ftSession = Search.getFullTextSession((Session)this.em.unwrap(Session.class));
            return (T)ftSession;
        }
        return (T)this.em.unwrap(type);
    }

    public Object getDelegate() {
        return this.em.getDelegate();
    }

    public void close() {
        this.em.close();
    }

    public boolean isOpen() {
        return this.em.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.em.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.em.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.em.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.em.getMetamodel();
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        return this.getFullTextSession().createIndexer(types);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.em.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.em.createQuery(deleteQuery);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.em.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.em.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.em.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.em.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public boolean isJoinedToTransaction() {
        return this.em.isJoinedToTransaction();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.em.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.em.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.em.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.em.getEntityGraphs(entityClass);
    }
}

