/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.index.impl.lucene.ConnectionBroker;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexConnectionBroker;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.ReadOnlyIndexConnectionBroker;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LuceneKernelExtension
extends LifecycleAdapter {
    private final Config config;
    private final GraphDatabaseService gdb;
    private final TransactionManager txManager;
    private final IndexStore indexStore;
    private final XaFactory xaFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final XaDataSourceManager xaDataSourceManager;
    private final IndexProviders indexProviders;

    public LuceneKernelExtension(Config config, GraphDatabaseService gdb, TransactionManager txManager, IndexStore indexStore, XaFactory xaFactory, FileSystemAbstraction fileSystemAbstraction, XaDataSourceManager xaDataSourceManager, IndexProviders indexProviders) {
        this.config = config;
        this.gdb = gdb;
        this.txManager = txManager;
        this.indexStore = indexStore;
        this.xaFactory = xaFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.xaDataSourceManager = xaDataSourceManager;
        this.indexProviders = indexProviders;
    }

    public void start() throws Throwable {
        LuceneDataSource luceneDataSource = new LuceneDataSource(this.config, this.indexStore, this.fileSystemAbstraction, this.xaFactory);
        this.xaDataSourceManager.registerDataSource((XaDataSource)luceneDataSource);
        Object broker = (Boolean)this.config.get(Configuration.read_only) != false ? new ReadOnlyIndexConnectionBroker(this.txManager) : new ConnectionBroker(this.txManager, luceneDataSource);
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation(this.gdb, luceneDataSource, (IndexConnectionBroker<LuceneXaConnection>)broker);
        this.indexProviders.registerIndexProvider("lucene", (IndexImplementation)indexImplementation);
    }

    public void stop() throws Throwable {
        this.xaDataSourceManager.unregisterDataSource("lucene-index");
        this.indexProviders.unregisterIndexProvider("lucene");
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
    }
}

