/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public interface DirectoryFactory
extends FileSystemAbstraction.ThirdPartyFileSystem {
    public static final DirectoryFactory PERSISTENT = new DirectoryFactory(){

        @Override
        public Directory open(File dir) throws IOException {
            dir.mkdirs();
            return FSDirectory.open((File)dir);
        }

        @Override
        public void close() {
        }
    };

    public Directory open(File var1) throws IOException;

    public void close();

    public static final class UncloseableDirectory
    extends Directory {
        private final Directory delegate;

        public UncloseableDirectory(Directory delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
        }

        public String[] listAll() throws IOException {
            return this.delegate.listAll();
        }

        public boolean fileExists(String s) throws IOException {
            return this.delegate.fileExists(s);
        }

        @Deprecated
        public long fileModified(String s) throws IOException {
            return this.delegate.fileModified(s);
        }

        @Deprecated
        public void touchFile(String s) throws IOException {
            this.delegate.touchFile(s);
        }

        public void deleteFile(String s) throws IOException {
            this.delegate.deleteFile(s);
        }

        public long fileLength(String s) throws IOException {
            return this.delegate.fileLength(s);
        }

        public IndexOutput createOutput(String s) throws IOException {
            return this.delegate.createOutput(s);
        }

        @Deprecated
        public void sync(String name) throws IOException {
            this.delegate.sync(name);
        }

        public void sync(Collection<String> names) throws IOException {
            this.delegate.sync(names);
        }

        public IndexInput openInput(String s) throws IOException {
            return this.delegate.openInput(s);
        }

        public IndexInput openInput(String name, int bufferSize) throws IOException {
            return this.delegate.openInput(name, bufferSize);
        }

        public Lock makeLock(String name) {
            return this.delegate.makeLock(name);
        }

        public void clearLock(String name) throws IOException {
            this.delegate.clearLock(name);
        }

        public void setLockFactory(LockFactory lockFactory) throws IOException {
            this.delegate.setLockFactory(lockFactory);
        }

        public LockFactory getLockFactory() {
            return this.delegate.getLockFactory();
        }

        public String getLockID() {
            return this.delegate.getLockID();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void copy(Directory to, String src, String dest) throws IOException {
            this.delegate.copy(to, src, dest);
        }

        @Deprecated
        public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
            Directory.copy((Directory)src, (Directory)dest, (boolean)closeDirSrc);
        }
    }

    public static final class Single
    implements DirectoryFactory {
        private final Directory directory;

        public Single(Directory directory) {
            this.directory = directory;
        }

        @Override
        public Directory open(File dir) throws IOException {
            return this.directory;
        }

        @Override
        public void close() {
        }
    }

    public static final class InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<File, RAMDirectory> directories = new HashMap<File, RAMDirectory>();

        @Override
        public synchronized Directory open(File dir) throws IOException {
            if (!this.directories.containsKey(dir)) {
                this.directories.put(dir, new RAMDirectory());
            }
            return new UncloseableDirectory((Directory)this.directories.get(dir));
        }

        @Override
        public synchronized void close() {
            for (RAMDirectory ramDirectory : this.directories.values()) {
                ramDirectory.close();
            }
            this.directories.clear();
        }
    }
}

