/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneUtil;

class LuceneDocumentStructure {
    private static final String NODE_ID_KEY = "_id_";
    private static final String SINGLE_PROPERTY_KEY = "key";

    LuceneDocumentStructure() {
    }

    Document newDocument(long nodeId, Object value) {
        Document document = IndexType.newBaseDocument(nodeId);
        document.add((Fieldable)new Field(NODE_ID_KEY, "" + nodeId, Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add(IndexType.instantiateField(SINGLE_PROPERTY_KEY, value, Field.Index.NOT_ANALYZED));
        return document;
    }

    public Query newQuery(Object value) {
        if (value instanceof String) {
            return new TermQuery(new Term(SINGLE_PROPERTY_KEY, (String)value));
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return LuceneUtil.rangeQuery(SINGLE_PROPERTY_KEY, number, number, true, true);
        }
        throw new UnsupportedOperationException(value.toString() + ", " + value.getClass());
    }

    public Term newQueryForChangeOrRemove(long nodeId) {
        return new Term(NODE_ID_KEY, "" + nodeId);
    }

    public long getNodeId(Document from) {
        return Long.parseLong(from.get(NODE_ID_KEY));
    }
}

