/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.index.impl.lucene.HitsIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.index.IndexReader;

class LuceneIndexAccessorReader
implements IndexReader {
    private final IndexSearcher searcher;
    private final LuceneDocumentStructure documentLogic;
    private final SearcherManager searcherManager;

    LuceneIndexAccessorReader(SearcherManager searcherManager, LuceneDocumentStructure documentLogic) {
        this.searcherManager = searcherManager;
        this.searcher = (IndexSearcher)searcherManager.acquire();
        this.documentLogic = documentLogic;
    }

    public Iterator<Long> lookup(Object value) {
        try {
            Hits hits = new Hits(this.searcher, this.documentLogic.newQuery(value), null);
            HitsIterator docs = new HitsIterator(hits);
            return Iterables.map((Function)new Function<Document, Long>(){

                public Long apply(Document from) {
                    return LuceneIndexAccessorReader.this.documentLogic.getNodeId(from);
                }
            }, (Iterator)((Object)docs));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherManager.release((Object)this.searcher);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

