/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.UniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;

public class LuceneSchemaIndexProvider
extends SchemaIndexProvider {
    private final DirectoryFactory directoryFactory;
    private final LuceneDocumentStructure documentStructure = new LuceneDocumentStructure();
    private final IndexWriterStatus writerStatus = new IndexWriterStatus();
    private final File rootDirectory;

    public LuceneSchemaIndexProvider(DirectoryFactory directoryFactory, Config config) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        this.directoryFactory = directoryFactory;
        this.rootDirectory = this.getRootDirectory(config, "lucene");
    }

    private File dirFile(long indexId) {
        return new File(this.rootDirectory, "" + indexId);
    }

    public IndexPopulator getPopulator(long indexId, IndexConfiguration config) {
        if (config.isUnique()) {
            return new UniqueLuceneIndexPopulator(1024, this.documentStructure, IndexWriterFactories.standard(), this.writerStatus, this.directoryFactory, this.dirFile(indexId));
        }
        return new NonUniqueLuceneIndexPopulator(10000, this.documentStructure, IndexWriterFactories.standard(), this.writerStatus, this.directoryFactory, this.dirFile(indexId));
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config) throws IOException {
        if (config.isUnique()) {
            return new UniqueLuceneIndexAccessor(this.documentStructure, IndexWriterFactories.standard(), this.writerStatus, this.directoryFactory, this.dirFile(indexId));
        }
        return new NonUniqueLuceneIndexAccessor(this.documentStructure, IndexWriterFactories.standard(), this.writerStatus, this.directoryFactory, this.dirFile(indexId));
    }

    public void shutdown() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexState getInitialState(long indexId) {
        InternalIndexState internalIndexState;
        Directory directory = this.directoryFactory.open(this.dirFile(indexId));
        try {
            boolean status = this.writerStatus.isOnline(directory);
            internalIndexState = status ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (Throwable throwable) {
            try {
                directory.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        directory.close();
        return internalIndexState;
    }
}

