/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    static final int DEFAULT_QUEUE_THRESHOLD = 10000;
    private final int queueThreshold;
    private final List<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();

    NonUniqueLuceneIndexPopulator(int queueThreshold, LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile);
        this.queueThreshold = queueThreshold;
    }

    public void add(long nodeId, Object propertyValue) throws IOException {
        this.writer.addDocument(this.documentStructure.newDocument(nodeId, propertyValue));
    }

    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        for (NodePropertyUpdate update : updates) {
            this.updates.add(update);
        }
        if (this.updates.size() > this.queueThreshold) {
            this.flush();
            this.updates.clear();
        }
    }

    @Override
    protected void flush() throws IOException {
        for (NodePropertyUpdate update : this.updates) {
            long nodeId = update.getNodeId();
            switch (update.getUpdateMode()) {
                case ADDED: {
                    this.writer.addDocument(this.documentStructure.newDocument(nodeId, update.getValueAfter()));
                    break;
                }
                case CHANGED: {
                    this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocument(nodeId, update.getValueAfter()));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(this.documentStructure.newQueryForChangeOrRemove(nodeId));
                }
            }
        }
    }
}

