/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.PropertyUpdateUniquenessValidator;

class UniqueLuceneIndexAccessor
extends LuceneIndexAccessor
implements PropertyUpdateUniquenessValidator.Lookup {
    public UniqueLuceneIndexAccessor(LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) throws IOException {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile);
    }

    @Override
    public void updateAndCommit(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
        PropertyUpdateUniquenessValidator.validateUniqueness(updates, (PropertyUpdateUniquenessValidator.Lookup)this);
        super.updateAndCommit(updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long currentlyIndexedNode(Object value) throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs docs = searcher.search(this.documentStructure.newQuery(value), 1);
            if (docs.scoreDocs.length > 0) {
                Document doc = searcher.getIndexReader().document(docs.scoreDocs[0].doc);
                Long l = this.documentStructure.getNodeId(doc);
                return l;
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
        return null;
    }
}

