/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.builtin.impl.BuiltinArrayBridge;

public class BuiltinNumericArrayBridge
extends BuiltinArrayBridge {
    public BuiltinNumericArrayBridge(FieldBridge fieldBridge) {
        super(fieldBridge);
    }

    public BuiltinNumericArrayBridge() {
        super(new FieldBridge(){

            @Override
            public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
                if (value == null) {
                    this.manageNull(name, document, luceneOptions);
                } else {
                    luceneOptions.addNumericFieldToDocument(name, value, document);
                }
            }

            private void manageNull(String name, Document document, LuceneOptions luceneOptions) {
                if (luceneOptions.indexNullAs() != null) {
                    luceneOptions.addFieldToDocument(name, luceneOptions.indexNullAs(), document);
                }
            }
        });
    }
}

