/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public abstract class BaseNeo4jSequenceGenerator {
    protected static final String INITIAL_VALUE_QUERY_PARAM = "initialValue";
    protected static final String SEQUENCE_NAME_QUERY_PARAM = "sequenceName";
    protected static final String SEQUENCE_NAME_PROPERTY = "sequence_name";
    protected static final String SEQUENCE_VALUE_PROPERTY = "next_val";

    protected String createUniqueConstraintQuery(String propertyName, String label) {
        StringBuilder query = new StringBuilder("CREATE CONSTRAINT ON (n:");
        query.append(label);
        query.append(") ASSERT n.");
        CypherDSL.escapeIdentifier(query, propertyName);
        query.append(" IS UNIQUE");
        return query.toString();
    }

    protected String key(NextValueRequest request) {
        return request.getKey().getTable() + ":" + request.getInitialValue() + ":" + request.getIncrement();
    }

    protected String sequenceName(IdSourceKey key) {
        return key.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE ? key.getMetadata().getName() : key.getColumnValue();
    }

    protected Map<String, Object> params(NextValueRequest request) {
        return this.params(this.sequenceName(request.getKey()), request.getInitialValue());
    }

    protected Map<String, Object> params(Sequence sequence) {
        return this.params(sequence.getName().render(), sequence.getInitialValue());
    }

    private Map<String, Object> params(String sequenceName, int initialValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(INITIAL_VALUE_QUERY_PARAM, initialValue);
        params.put(SEQUENCE_NAME_QUERY_PARAM, sequenceName);
        return params;
    }

    protected String labels(String ... labels) {
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(":`");
            builder.append(label);
            builder.append("`");
        }
        return builder.toString();
    }

    public abstract Long nextValue(NextValueRequest var1);
}

