/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.EmbeddedHelper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;

public class EmbeddedNeo4jAssociationQueries
extends BaseNeo4jAssociationQueries {
    public EmbeddedNeo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        super(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    @Override
    public void removeAssociation(GraphDatabaseService executionEngine, AssociationKey associationKey) {
        executionEngine.execute(this.removeAssociationQuery, this.params(associationKey.getEntityKey().getColumnValues()));
    }

    @Override
    public Relationship findRelationship(GraphDatabaseService executionEngine, AssociationKey associationKey, RowKey rowKey) {
        Object[] queryValues = this.relationshipValues(associationKey, rowKey);
        Result result = executionEngine.execute(this.findRelationshipQuery, this.params(queryValues));
        return (Relationship)this.singleResult(result);
    }

    @Override
    protected Object[] relationshipValues(AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues;
        if (associationKey.getMetadata().getRowKeyIndexColumnNames().length > 0) {
            int length = associationKey.getMetadata().getRowKeyIndexColumnNames().length;
            relationshipValues = new Object[length];
            String[] indexColumnNames = associationKey.getMetadata().getRowKeyIndexColumnNames();
            for (int i = 0; i < indexColumnNames.length; ++i) {
                for (int j = 0; j < rowKey.getColumnNames().length; ++j) {
                    if (!indexColumnNames[i].equals(rowKey.getColumnNames()[j])) continue;
                    relationshipValues[i] = rowKey.getColumnValues()[j];
                }
            }
        } else {
            relationshipValues = this.getEntityKey(associationKey, rowKey).getColumnValues();
        }
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        return queryValues;
    }

    @Override
    public void removeAssociationRow(GraphDatabaseService executionEngine, AssociationKey associationKey, RowKey rowKey) {
        Object[] queryValues = this.relationshipValues(associationKey, rowKey);
        executionEngine.execute(this.removeAssociationRowQuery, this.params(queryValues));
    }

    private EntityKey getEntityKey(AssociationKey associationKey, RowKey rowKey) {
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        Object[] columnValues = new Object[associationKeyColumns.length];
        int i = 0;
        for (String associationKeyColumn : associationKeyColumns) {
            columnValues[i] = rowKey.getColumnValue(associationKeyColumn);
            ++i;
        }
        EntityKeyMetadata entityKeyMetadata = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
        return new EntityKey(entityKeyMetadata, columnValues);
    }

    public Relationship createRelationshipForEmbeddedAssociation(GraphDatabaseService executionEngine, AssociationKey associationKey, EntityKey embeddedKey) {
        String query = this.initCreateEmbeddedAssociationQuery(associationKey, embeddedKey);
        Object[] queryValues = this.createRelationshipForEmbeddedQueryValues(associationKey, embeddedKey);
        return this.executeQuery(executionEngine, query, queryValues);
    }

    @Override
    protected String initCreateEmbeddedAssociationQuery(AssociationKey associationKey, EntityKey embeddedKey) {
        String collectionRole = associationKey.getMetadata().getCollectionRole();
        String[] embeddedColumnNames = embeddedKey.getColumnNames();
        Object[] embeddedColumnValues = embeddedKey.getColumnValues();
        String[] columnNames = associationKey.getEntityKey().getMetadata().getColumnNames();
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(this.matchOwnerEntityNode);
        if (this.isCollectionOfPrimitives(collectionRole, embeddedColumnNames)) {
            this.createRelationshipForCollectionOfPrimitivesOrMap(associationKey, collectionRole, columnNames, queryBuilder);
        } else {
            this.createRelationshipforCollectionOfComponents(associationKey, collectionRole, embeddedColumnNames, embeddedColumnValues, queryBuilder);
        }
        return queryBuilder.toString();
    }

    protected Object[] createRelationshipForEmbeddedQueryValues(AssociationKey associationKey, EntityKey embeddedKey) {
        String collectionRole = associationKey.getMetadata().getCollectionRole();
        Object[] columnValues = associationKey.getEntityKey().getColumnValues();
        if (this.isCollectionOfPrimitives(collectionRole, embeddedKey.getColumnNames())) {
            return ArrayHelper.concat((Object[])columnValues, (Object[])new Object[]{embeddedKey.getColumnValues()[0]});
        }
        return ArrayHelper.concat((Object[])columnValues, (Object[])embeddedKey.getColumnValues());
    }

    private boolean isCollectionOfPrimitives(String collectionRole, String[] embeddedColumnNames) {
        return embeddedColumnNames.length == 1 && collectionRole.equals(embeddedColumnNames[0]);
    }

    private void createRelationshipforCollectionOfComponents(AssociationKey associationKey, String collectionRole, String[] embeddedColumnNames, Object[] embeddedColumnValues, StringBuilder queryBuilder) {
        int offset = associationKey.getEntityKey().getColumnNames().length;
        EmbeddedNodesTree tree = this.createEmbeddedTree(collectionRole, embeddedColumnNames, embeddedColumnValues, offset);
        if (EmbeddedHelper.isPartOfEmbedded((String)collectionRole)) {
            String[] pathToEmbedded = EmbeddedNeo4jAssociationQueries.appendEmbeddedNodes(collectionRole, queryBuilder);
            queryBuilder.append(" CREATE (e) -[r:");
            EmbeddedNeo4jAssociationQueries.appendRelationshipType(queryBuilder, pathToEmbedded[pathToEmbedded.length - 1]);
        } else {
            queryBuilder.append(" CREATE (owner) -[r:");
            EmbeddedNeo4jAssociationQueries.appendRelationshipType(queryBuilder, collectionRole);
        }
        queryBuilder.append("]-> ");
        queryBuilder.append("(target:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(":");
        CypherDSL.escapeIdentifier(queryBuilder, associationKey.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getTable());
        int index = 0;
        int embeddedNumber = 0;
        if (!tree.getProperties().isEmpty()) {
            queryBuilder.append(" {");
            for (EmbeddedNodeProperty property : tree.getProperties()) {
                CypherDSL.escapeIdentifier(queryBuilder, property.getColumn());
                queryBuilder.append(": {");
                queryBuilder.append(property.getParam());
                queryBuilder.append("}");
                if (index++ >= tree.getProperties().size() - 1) continue;
                queryBuilder.append(", ");
            }
            queryBuilder.append("}");
        }
        queryBuilder.append(")");
        Map<String, EmbeddedNodesTree> children = tree.getChildren();
        boolean first = true;
        for (Map.Entry<String, EmbeddedNodesTree> entry : children.entrySet()) {
            index = 0;
            String relationshipType = entry.getKey();
            EmbeddedNodesTree child = entry.getValue();
            if (first) {
                first = false;
            } else {
                queryBuilder.append(", (target)");
            }
            queryBuilder.append(" - [:");
            EmbeddedNeo4jAssociationQueries.appendRelationshipType(queryBuilder, relationshipType);
            queryBuilder.append("] -> ");
            queryBuilder.append("(a");
            queryBuilder.append(embeddedNumber++);
            queryBuilder.append(":");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
            if (!child.getProperties().isEmpty()) {
                queryBuilder.append(" {");
                for (EmbeddedNodeProperty property : child.getProperties()) {
                    CypherDSL.escapeIdentifier(queryBuilder, property.getColumn());
                    queryBuilder.append(": {");
                    queryBuilder.append(property.getParam());
                    queryBuilder.append("}");
                    if (index++ >= child.getProperties().size() - 1) continue;
                    queryBuilder.append(", ");
                }
                queryBuilder.append("}");
            }
            queryBuilder.append(")");
        }
        queryBuilder.append(" RETURN r");
    }

    private void createRelationshipForCollectionOfPrimitivesOrMap(AssociationKey associationKey, String collectionRole, String[] columnNames, StringBuilder queryBuilder) {
        String relationshipType = collectionRole;
        if (EmbeddedHelper.isPartOfEmbedded((String)collectionRole)) {
            queryBuilder.append(" MERGE (owner) ");
            String[] pathToEmbedded = EmbeddedNeo4jAssociationQueries.appendEmbeddedNodes(collectionRole, queryBuilder);
            relationshipType = pathToEmbedded[pathToEmbedded.length - 1];
            queryBuilder.append(" CREATE (e) -[r:");
        } else {
            queryBuilder.append(" CREATE (owner) -[r:");
        }
        CypherDSL.escapeIdentifier(queryBuilder, relationshipType);
        queryBuilder.append("]->(new:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(":");
        CypherDSL.escapeIdentifier(queryBuilder, associationKey.getTable());
        queryBuilder.append(" {");
        CypherDSL.escapeIdentifier(queryBuilder, relationshipType);
        queryBuilder.append(": {");
        queryBuilder.append(columnNames.length);
        queryBuilder.append("}");
        queryBuilder.append("}");
        queryBuilder.append(")");
        queryBuilder.append(" RETURN r");
    }

    private Relationship executeQuery(GraphDatabaseService executionEngine, String query, Object[] queryValues) {
        Map<String, Object> params = this.params(queryValues);
        Result result = executionEngine.execute(query, params);
        return (Relationship)this.singleResult(result);
    }

    private EmbeddedNodesTree createEmbeddedTree(String collectionRole, String[] embeddedColumnNames, Object[] embeddedColumnValues, int offset) {
        EmbeddedNodesTree tree = new EmbeddedNodesTree();
        for (int i = 0; i < embeddedColumnNames.length; ++i) {
            String embeddedColumnName = embeddedColumnNames[i].startsWith(collectionRole) ? embeddedColumnNames[i].substring(collectionRole.length() + 1) : embeddedColumnNames[i];
            if (embeddedColumnValues[i] == null) continue;
            if (embeddedColumnName.contains(".")) {
                int firstDot = embeddedColumnName.indexOf(".");
                String relationshipType = embeddedColumnName.substring(0, firstDot);
                String currentProperty = embeddedColumnName.substring(firstDot + 1);
                this.appendSubTree(tree, currentProperty, relationshipType, offset + i);
                continue;
            }
            EmbeddedNodeProperty property = new EmbeddedNodeProperty();
            property.setParam(offset + i);
            property.setColumn(embeddedColumnName);
            tree.addProperty(property);
        }
        return tree;
    }

    private void appendSubTree(EmbeddedNodesTree tree, String currentProperty, String relationshipType, int index) {
        EmbeddedNodesTree subTree = tree.getChild(relationshipType);
        if (subTree == null) {
            subTree = new EmbeddedNodesTree();
            tree.addChild(relationshipType, subTree);
        }
        if (EmbeddedHelper.isPartOfEmbedded((String)currentProperty)) {
            int firstDot = currentProperty.indexOf(".");
            String relType = currentProperty.substring(0, firstDot);
            String subProperty = currentProperty.substring(firstDot + 1);
            this.appendSubTree(tree, subProperty, relType, index);
        } else {
            EmbeddedNodeProperty property = new EmbeddedNodeProperty();
            property.setColumn(currentProperty);
            property.setParam(index);
            subTree.addProperty(property);
        }
    }

    private static String[] appendEmbeddedNodes(String path, StringBuilder queryBuilder) {
        String[] columns = EmbeddedHelper.split((String)path);
        for (int i = 0; i < columns.length - 1; ++i) {
            queryBuilder.append(" - [:");
            EmbeddedNeo4jAssociationQueries.appendRelationshipType(queryBuilder, columns[i]);
            queryBuilder.append("] ->");
            if (i >= columns.length - 2) continue;
            queryBuilder.append(" (e");
            queryBuilder.append(i);
            queryBuilder.append(":");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
            queryBuilder.append(") MERGE (e");
            queryBuilder.append(i);
            queryBuilder.append(")");
        }
        queryBuilder.append(" (e:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(")");
        return columns;
    }

    private class EmbeddedNodeProperty {
        private String column;
        private int param;

        private EmbeddedNodeProperty() {
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public int getParam() {
            return this.param;
        }

        public void setParam(int param) {
            this.param = param;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.column);
            builder.append(", ");
            builder.append(this.param);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class EmbeddedNodesTree {
        final List<EmbeddedNodeProperty> properties = new ArrayList<EmbeddedNodeProperty>();
        final Map<String, EmbeddedNodesTree> children = new HashMap<String, EmbeddedNodesTree>();

        private EmbeddedNodesTree() {
        }

        public void addProperty(EmbeddedNodeProperty property) {
            this.properties.add(property);
        }

        public List<EmbeddedNodeProperty> getProperties() {
            return this.properties;
        }

        public void addChild(String relationshipType, EmbeddedNodesTree subTree) {
            this.children.put(relationshipType, subTree);
        }

        public EmbeddedNodesTree getChild(String relationshipType) {
            return this.children.get(relationshipType);
        }

        public Map<String, EmbeddedNodesTree> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EmbeddedTree [properties=");
            builder.append(this.properties);
            builder.append(", children=");
            builder.append(this.children);
            builder.append("]");
            return builder.toString();
        }
    }
}

