/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.Collections;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jEntityQueries;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;

public class EmbeddedNeo4jEntityQueries
extends BaseNeo4jEntityQueries {
    public EmbeddedNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata) {
        this(entityKeyMetadata, null);
    }

    public EmbeddedNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        super(entityKeyMetadata, tupleTypeContext, false);
    }

    public ResourceIterator<Relationship> findAssociation(GraphDatabaseService executionEngine, Object[] columnValues, String role, AssociationKeyMetadata associationKeyMetadata) {
        String query = this.getFindAssociationQuery(role, associationKeyMetadata);
        Map<String, Object> params = this.params(columnValues);
        executionEngine.execute(query, params);
        return executionEngine.execute(query, this.params(columnValues)).columnAs("r");
    }

    public Node createEmbedded(GraphDatabaseService executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        Result result = executionEngine.execute(this.getCreateEmbeddedNodeQuery(), params);
        return (Node)this.singleResult(result);
    }

    public Node findEntity(GraphDatabaseService executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        Result result = executionEngine.execute(this.getFindEntityQuery(), params);
        return (Node)this.singleResult(result);
    }

    public ResourceIterator<Node> findEntities(GraphDatabaseService executionEngine, EntityKey[] keys) {
        if (this.singlePropertyKey) {
            return this.singlePropertyIdFindEntities(executionEngine, keys);
        }
        return this.multiPropertiesIdFindEntities(executionEngine, keys);
    }

    private ResourceIterator<Node> multiPropertiesIdFindEntities(GraphDatabaseService executionEngine, EntityKey[] keys) {
        String query = this.getMultiGetQueryCacheQuery(keys);
        Map<String, Object> params = this.multiGetParams(keys);
        Result result = executionEngine.execute(query, params);
        return result.columnAs("owner");
    }

    private ResourceIterator<Node> singlePropertyIdFindEntities(GraphDatabaseService executionEngine, EntityKey[] keys) {
        Object[] paramsValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            paramsValues[i] = keys[i].getColumnValues()[0];
        }
        Map<String, Object[]> params = Collections.singletonMap("0", paramsValues);
        Result result = executionEngine.execute(this.multiGetQuery, params);
        return result.columnAs("owner");
    }

    public Node insertEntity(GraphDatabaseService executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        Result result = executionEngine.execute(this.getCreateEntityQuery(), params);
        return (Node)this.singleResult(result);
    }

    public ResourceIterator<Node> findEntities(GraphDatabaseService executionEngine) {
        Result result = executionEngine.execute(this.getFindEntitiesQuery());
        return result.columnAs("owner");
    }

    public void removeEntity(GraphDatabaseService executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        executionEngine.execute(this.getRemoveEntityQuery(), params);
    }

    public void updateEmbeddedColumn(GraphDatabaseService executionEngine, Object[] keyValues, String embeddedColumn, Object value) {
        String query = this.getUpdateEmbeddedColumnQuery(keyValues, embeddedColumn);
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])keyValues, (Object[])new Object[]{value, value}));
        executionEngine.execute(query, params);
    }
}

