/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl;

import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl.EmbeddedNeo4jJtaTransactionCoordinator;
import org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl.EmbeddedNeo4jResourceLocalTransactionCoordinator;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public class EmbeddedNeo4jTransactionCoordinatorBuilder
implements TransactionCoordinatorBuilder {
    private final EmbeddedNeo4jDatastoreProvider datastoreProvider;
    private final TransactionCoordinatorBuilder delegate;

    public EmbeddedNeo4jTransactionCoordinatorBuilder(TransactionCoordinatorBuilder delegate, EmbeddedNeo4jDatastoreProvider datastoreProvider) {
        this.delegate = delegate;
        this.datastoreProvider = datastoreProvider;
    }

    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.Options options) {
        if (this.delegate.isJta()) {
            TransactionCoordinator coordinator = this.delegate.buildTransactionCoordinator(owner, options);
            return new EmbeddedNeo4jJtaTransactionCoordinator(coordinator, this.datastoreProvider);
        }
        return new EmbeddedNeo4jResourceLocalTransactionCoordinator(this, owner, this.datastoreProvider);
    }

    public boolean isJta() {
        return this.delegate.isJta();
    }

    public ConnectionReleaseMode getDefaultConnectionReleaseMode() {
        return this.delegate.getDefaultConnectionReleaseMode();
    }

    public ConnectionAcquisitionMode getDefaultConnectionAcquisitionMode() {
        return this.delegate.getDefaultConnectionAcquisitionMode();
    }

    public PhysicalConnectionHandlingMode getDefaultConnectionHandlingMode() {
        return this.delegate.getDefaultConnectionHandlingMode();
    }
}

