/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jAliasResolver;

public class Neo4jQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Map<String, String> entityNameByAlias = new HashMap<String, String>();
    private final Map<String, PropertyPath> propertyPathByAlias = new HashMap<String, PropertyPath>();
    private final Neo4jAliasResolver aliasResolver;
    private String currentAlias;

    public Neo4jQueryResolverDelegate(Neo4jAliasResolver aliasResolver) {
        this.aliasResolver = aliasResolver;
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.entityNameByAlias.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        this.aliasResolver.registerEntityAlias(entityName.getText(), alias.getText());
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        PropertyPath put = this.propertyPathByAlias.put(alias.getText(), path);
        if (put != null && !put.equals(path)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        return new PathedPropertyReference(property.getText(), null, this.isAlias(property));
    }

    public boolean isPersisterReferenceAlias() {
        return this.isEntityAlias(this.currentAlias);
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree root) {
        return new PathedPropertyReference(root.getText(), null, this.isAlias(root));
    }

    private boolean isAlias(Tree root) {
        return this.isEntityAlias(root.getText()) || this.propertyPathByAlias.containsKey(root.getText());
    }

    private boolean isEntityAlias(String alias) {
        return this.entityNameByAlias.containsKey(alias);
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.entityNameByAlias.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        return new PathedPropertyReference(root.getText(), null, true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        return new PathedPropertyReference(propertyName.getText(), null, false);
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return new PathedPropertyReference(propertyNameNode.getText(), null, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.currentAlias = alias.getText();
    }

    public void pushSelectStrategy() {
    }

    public void popStrategy() {
    }

    public void propertyPathCompleted(PropertyPath path) {
    }
}

