/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.BaseNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.driver.v1.types.Node;

public final class BoltNeo4jTupleSnapshot
implements TupleSnapshot {
    private final Node node;
    private final Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata;
    private final EntityKeyMetadata entityKeyMetadata;
    private final Map<String, Node> toOneEntities;
    private final Map<String, Collection<Node>> embeddedNodes;
    private final Map<String, String> rolesByColumn;

    public BoltNeo4jTupleSnapshot(NodeWithEmbeddedNodes node, EntityKeyMetadata entityKeyMetadata) {
        this(node, entityKeyMetadata, Collections.emptyMap(), null);
    }

    public BoltNeo4jTupleSnapshot(NodeWithEmbeddedNodes node, EntityKeyMetadata metadata, Map<String, Node> toOneEntities, TupleTypeContext tupleTypeContext) {
        this.node = node.getOwner();
        this.embeddedNodes = node.getEmbeddedNodes();
        this.entityKeyMetadata = metadata;
        this.toOneEntities = toOneEntities;
        this.associatedEntityKeyMetadata = tupleTypeContext.getAllAssociatedEntityKeyMetadata();
        this.rolesByColumn = tupleTypeContext.getAllRoles();
    }

    public Object get(String column) {
        if (this.associatedEntityKeyMetadata.containsKey(column)) {
            return this.readPropertyOnOtherNode(column);
        }
        if (BaseNeo4jDialect.isPartOfRegularEmbedded(this.entityKeyMetadata.getColumnNames(), column)) {
            return this.readEmbeddedProperty(column);
        }
        return this.readProperty(this.node, column);
    }

    private Object readPropertyOnOtherNode(String column) {
        String associationrole = this.rolesByColumn.get(column);
        Node associatedEntity = this.toOneEntities.get(associationrole);
        if (associatedEntity == null) {
            return null;
        }
        return this.readProperty(associatedEntity, this.associatedEntityKeyMetadata.get(column).getCorrespondingEntityKeyColumn(column));
    }

    private Object readEmbeddedProperty(String column) {
        String embeddedPath = column.substring(0, column.lastIndexOf("."));
        String property = column.substring(embeddedPath.length() + 1);
        if (this.embeddedNodes.containsKey(embeddedPath)) {
            Node embeddedNode = this.embeddedNodes.get(embeddedPath).iterator().next();
            return this.readProperty(embeddedNode, property);
        }
        return null;
    }

    private Object readProperty(Node node, String targetColumnName) {
        if (node.containsKey(targetColumnName)) {
            return node.get(targetColumnName).asObject();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.node.asMap().isEmpty();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.keys()) {
            names.add(string);
        }
        return names;
    }

    public Node getNode() {
        return this.node;
    }
}

