/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationPropertiesRow;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.EmbeddedHelper;

public class RemoteNeo4jTupleAssociationSnapshot
implements TupleSnapshot {
    private final Map<String, Object> properties;

    public RemoteNeo4jTupleAssociationSnapshot(RemoteNeo4jAssociationPropertiesRow row, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        this.properties = RemoteNeo4jTupleAssociationSnapshot.collectProperties(row, associationKey, associatedEntityKeyMetadata);
    }

    public Object get(String column) {
        return this.properties.get(column);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }

    private static Map<String, Object> collectProperties(RemoteNeo4jAssociationPropertiesRow row, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] rowKeyColumnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Map<String, Object> relationship = row.getRelationship();
        Map<String, Object> ownerNode = row.getOwnerNode();
        Map<String, Object> targetNode = row.getTargetNode();
        for (int i = 0; i < rowKeyColumnNames.length; ++i) {
            if (!relationship.containsKey(rowKeyColumnNames[i])) continue;
            properties.put(rowKeyColumnNames[i], relationship.get(rowKeyColumnNames[i]));
        }
        for (String associationColumn : associatedEntityKeyMetadata.getAssociationKeyColumns()) {
            String targetColumnName = associatedEntityKeyMetadata.getCorrespondingEntityKeyColumn(associationColumn);
            if (EmbeddedHelper.isPartOfEmbedded((String)targetColumnName)) {
                RemoteNeo4jTupleAssociationSnapshot.fetchEmbeddedProperties(associationKey, properties, targetNode, associationColumn, targetColumnName);
                continue;
            }
            if (!targetNode.containsKey(targetColumnName)) continue;
            properties.put(associationColumn, targetNode.get(targetColumnName));
        }
        for (int i = 0; i < associationKey.getColumnNames().length; ++i) {
            String key = associationKey.getEntityKey().getColumnNames()[i];
            if (!ownerNode.containsKey(key)) continue;
            properties.put(associationKey.getColumnNames()[i], ownerNode.get(key));
        }
        return properties;
    }

    private static void fetchEmbeddedProperties(AssociationKey associationKey, Map<String, Object> properties, Map<String, Object> targetNode, String associationColumn, String targetColumnName) {
        String collectionRole = associationKey.getMetadata().getCollectionRole();
        if (targetColumnName.equals(collectionRole) && targetNode.containsKey(targetColumnName = targetColumnName.substring(targetColumnName.lastIndexOf(".") + 1))) {
            properties.put(associationColumn, targetNode.get(targetColumnName));
        }
        if (targetColumnName.startsWith(collectionRole)) {
            if (targetNode.containsKey(targetColumnName = targetColumnName.substring(collectionRole.length() + 1))) {
                properties.put(associationColumn, targetNode.get(targetColumnName));
            }
        } else if (targetNode.containsKey(targetColumnName)) {
            properties.put(associationColumn, targetNode.get(targetColumnName));
        } else if (targetNode.containsKey(targetColumnName)) {
            properties.put(associationColumn, targetNode.get(targetColumnName));
        }
    }
}

