/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.util.impl;

import java.util.Map;
import org.hibernate.ogm.model.key.spi.RowKey;

public class RemoteNeo4jHelper {
    private RemoteNeo4jHelper() {
    }

    public static boolean matches(Map<String, Object> nodeProperties, String[] keyColumnNames, Object[] keyColumnValues) {
        for (int i = 0; i < keyColumnNames.length; ++i) {
            Object actualValue;
            String property = keyColumnNames[i];
            Object expectedValue = keyColumnValues[i];
            boolean containsProperty = nodeProperties.containsKey(property);
            if (!(containsProperty ? !RemoteNeo4jHelper.sameValue(expectedValue, actualValue = nodeProperties.get(property)) : expectedValue != null)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(RowKey actual, RowKey expected) {
        if (actual.getColumnNames().length != expected.getColumnNames().length) {
            return false;
        }
        for (int i = 0; i < expected.getColumnNames().length; ++i) {
            Object actualValue;
            Object expectedValue = expected.getColumnValues()[i];
            if (RemoteNeo4jHelper.sameValue(expectedValue, actualValue = actual.getColumnValues()[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean sameValue(Object expectedValue, Object actualValue) {
        if (actualValue == null && expectedValue != null) {
            return false;
        }
        return actualValue == null || actualValue.equals(expectedValue) || actualValue instanceof Number && actualValue.toString().equals(expectedValue.toString());
    }
}

