/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.RemoteNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatement;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatements;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.ErrorResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statement;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementResult;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class HttpNeo4jSequenceGenerator
extends RemoteNeo4jSequenceGenerator {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final HttpNeo4jClient client;

    public HttpNeo4jSequenceGenerator(HttpNeo4jClient neo4jDb, int sequenceCacheMaxSize) {
        super(sequenceCacheMaxSize);
        this.client = neo4jDb;
    }

    private void createSequencesConstraintsStatements(Statements statements, Iterable<Sequence> sequences) {
        Statement statement = this.createUniqueConstraintStatement("sequence_name", NodeLabel.SEQUENCE.name());
        statements.addStatement(statement);
    }

    private Statements createSequencesStatements(Iterable<Sequence> sequences) {
        Statements statements = new Statements();
        for (Sequence sequence : sequences) {
            this.addSequence(statements, sequence);
        }
        return statements;
    }

    private void addSequence(Statements statements, Sequence sequence) {
        Statement statement = new Statement(SEQUENCE_CREATION_QUERY, Collections.singletonMap("sequenceName", sequence.getName().render()));
        statements.addStatement(statement);
    }

    private void addUniqueConstraintForTableBasedSequence(Statements statements, IdSourceKeyMetadata generatorKeyMetadata) {
        Statement statement = this.createUniqueConstraintStatement(generatorKeyMetadata.getKeyColumnName(), generatorKeyMetadata.getName());
        statements.addStatement(statement);
    }

    private Statement createUniqueConstraintStatement(String propertyName, String label) {
        String queryString = this.createUniqueConstraintQuery(propertyName, label);
        Statement statement = new Statement(queryString);
        return statement;
    }

    public void createUniqueConstraintsForTableSequences(Statements statements, Iterable<IdSourceKeyMetadata> tableIdGenerators) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : tableIdGenerators) {
            if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.TABLE) continue;
            this.addUniqueConstraintForTableBasedSequence(statements, idSourceKeyMetadata);
        }
    }

    @Override
    protected Number nextValue(RemoteStatements remoteStatements) {
        Statements statements = this.convert(remoteStatements);
        List<StatementResult> results = this.client.executeQueriesInNewTransaction(statements).getResults();
        Number nextValue = (Number)results.get(1).getData().get(0).getRow().get(0);
        return nextValue;
    }

    private Statements convert(RemoteStatements remoteStatements) {
        Statements statements = new Statements();
        for (RemoteStatement remoteStatement : remoteStatements) {
            Statement statement = new Statement();
            statement.setStatement(remoteStatement.getQuery());
            statement.setParameters(remoteStatement.getParams());
            if (remoteStatement.isAsRow()) {
                statement.setResultDataContents(Arrays.asList("row"));
            }
            statements.addStatement(statement);
        }
        return statements;
    }

    @Override
    public void createSequences(List<Sequence> sequences, Iterable<IdSourceKeyMetadata> idSourceKeyMetadata) {
        this.createUniqueConstraints(sequences, idSourceKeyMetadata);
        Statements statements = this.createSequencesStatements(sequences);
        StatementsResponse response = this.client.executeQueriesInNewTransaction(statements);
        this.validateSequencesCreation(response);
    }

    private void createUniqueConstraints(List<Sequence> sequences, Iterable<IdSourceKeyMetadata> idSourceKeyMetadata) {
        Statements statements = new Statements();
        this.createSequencesConstraintsStatements(statements, sequences);
        this.createUniqueConstraintsForTableSequences(statements, idSourceKeyMetadata);
        StatementsResponse response = this.client.executeQueriesInNewTransaction(statements);
        this.validateConstraintsCreation(response);
    }

    private void validateSequencesCreation(StatementsResponse response) {
        if (!response.getErrors().isEmpty()) {
            ErrorResponse errorResponse = response.getErrors().get(0);
            throw log.sequencesCreationException(errorResponse.getCode(), errorResponse.getMessage());
        }
    }

    private void validateConstraintsCreation(StatementsResponse response) {
        if (!response.getErrors().isEmpty()) {
            ErrorResponse errorResponse = response.getErrors().get(0);
            throw log.constraintsCreationException(errorResponse.getCode(), errorResponse.getMessage());
        }
    }
}

