/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl.json;

import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import java.util.Iterator;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.json.JsonSerializationStrategy;

public class JsonEntityStorageStrategy {
    private final JsonSerializationStrategy jsonSerializationStrategy;
    private final RedisClusterCommands<String, String> connection;

    public JsonEntityStorageStrategy(JsonSerializationStrategy jsonSerializationStrategy, RedisClusterCommands<String, String> connection) {
        this.jsonSerializationStrategy = jsonSerializationStrategy;
        this.connection = connection;
    }

    public Entity getEntity(String key) {
        String value = (String)this.connection.get((Object)key);
        return this.jsonSerializationStrategy.deserialize(value, Entity.class);
    }

    public void storeEntity(String key, Entity entity) {
        String value = this.jsonSerializationStrategy.serialize(entity);
        this.connection.set((Object)key, (Object)value);
    }

    public Iterable<Entity> getEntities(String[] keys) {
        final Iterator values = this.connection.mget((Object[])keys).iterator();
        return new Iterable<Entity>(){

            @Override
            public Iterator<Entity> iterator() {
                return new Iterator<Entity>(){

                    @Override
                    public boolean hasNext() {
                        return values.hasNext();
                    }

                    @Override
                    public Entity next() {
                        String value = (String)values.next();
                        return value != null ? JsonEntityStorageStrategy.this.jsonSerializationStrategy.deserialize(value, Entity.class) : null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal is not supported");
                    }
                };
            }
        };
    }
}

