/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.internal.entities.ComponentDescription;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;

public class EntityConfiguration {
    private final String versionsEntityName;
    private final String entityClassName;
    private final IdMappingData idMappingData;
    private final ExtendedPropertyMapper propertyMapper;
    private final Map<String, RelationDescription> relations;
    private final Map<String, ComponentDescription> components;
    private final String parentEntityName;

    public EntityConfiguration(String versionsEntityName, String entityClassName, IdMappingData idMappingData, ExtendedPropertyMapper propertyMapper, String parentEntityName) {
        this.versionsEntityName = versionsEntityName;
        this.entityClassName = entityClassName;
        this.idMappingData = idMappingData;
        this.propertyMapper = propertyMapper;
        this.parentEntityName = parentEntityName;
        this.relations = new HashMap<String, RelationDescription>();
        this.components = new HashMap<String, ComponentDescription>();
    }

    public void addToOneRelation(String fromPropertyName, String toEntityName, IdMapper idMapper, boolean insertable, boolean ignoreNotFound) {
        this.relations.put(fromPropertyName, RelationDescription.toOne(fromPropertyName, RelationType.TO_ONE, toEntityName, null, idMapper, null, null, insertable, ignoreNotFound));
    }

    public void addToOneNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper, boolean ignoreNotFound) {
        this.relations.put(fromPropertyName, RelationDescription.toOne(fromPropertyName, RelationType.TO_ONE_NOT_OWNING, toEntityName, mappedByPropertyName, idMapper, null, null, true, ignoreNotFound));
    }

    public void addToManyNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper, boolean indexed) {
        this.relations.put(fromPropertyName, RelationDescription.toMany(fromPropertyName, RelationType.TO_MANY_NOT_OWNING, toEntityName, mappedByPropertyName, idMapper, fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, null, null, null, true, indexed));
    }

    public void addToManyMiddleRelation(String fromPropertyName, String toEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, String auditMiddleEntityName) {
        this.relations.put(fromPropertyName, RelationDescription.toMany(fromPropertyName, RelationType.TO_MANY_MIDDLE, toEntityName, null, null, null, null, referencingIdData, referencedIdData, auditMiddleEntityName, true, false));
    }

    public void addToManyMiddleNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, String auditMiddleEntityName) {
        this.relations.put(fromPropertyName, RelationDescription.toMany(fromPropertyName, RelationType.TO_MANY_MIDDLE_NOT_OWNING, toEntityName, mappedByPropertyName, null, null, null, referencingIdData, referencedIdData, auditMiddleEntityName, true, false));
    }

    public void addToManyComponent(String propertyName, String auditMiddleEntityName, MiddleIdData middleIdData) {
        this.components.put(propertyName, ComponentDescription.many(propertyName, auditMiddleEntityName, middleIdData));
    }

    public void addToOneComponent(String propertyName, ComponentAuditingData auditingData) {
        this.components.put(propertyName, ComponentDescription.one(propertyName, auditingData));
    }

    public boolean isRelation(String propertyName) {
        return this.relations.get(propertyName) != null;
    }

    public RelationDescription getRelationDescription(String propertyName) {
        return this.relations.get(propertyName);
    }

    public ComponentDescription getComponentDescription(String propertyName) {
        return this.components.get(propertyName);
    }

    public IdMappingData getIdMappingData() {
        return this.idMappingData;
    }

    public IdMapper getIdMapper() {
        return this.idMappingData.getIdMapper();
    }

    public ExtendedPropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    public String getParentEntityName() {
        return this.parentEntityName;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    String getVersionsEntityName() {
        return this.versionsEntityName;
    }

    Iterable<RelationDescription> getRelationsIterator() {
        return this.relations.values();
    }
}

