
package org.hibernate.jpamodelgen.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * 
 *         The entity-mappings element is the root element of a mapping
 *         file. It contains the following four types of elements:
 * 
 *         1. The persistence-unit-metadata element contains metadata
 *         for the entire persistence unit. It is undefined if this element
 *         occurs in multiple mapping files within the same persistence unit.
 *         
 *         2. The package, schema, catalog and access elements apply to all of
 *         the entity, mapped-superclass and embeddable elements defined in
 *         the same file in which they occur.
 * 
 *         3. The sequence-generator, table-generator, converter, named-query,
 *         named-native-query, named-stored-procedure-query, and 
 *         sql-result-set-mapping elements are global to the persistence
 *         unit. It is undefined to have more than one sequence-generator
 *         or table-generator of the same name in the same or different
 *         mapping files in a persistence unit. It is undefined to have
 *         more than one named-query, named-native-query, sql-result-set-mapping,
 *         or named-stored-procedure-query of the same name in the same 
 *         or different mapping files in a persistence unit.  It is also
 *         undefined to have more than one converter for the same target
 *         type in the same or different mapping files in a persistence unit.
 * 
 *         4. The entity, mapped-superclass and embeddable elements each define
 *         the mapping information for a managed persistent class. The mapping
 *         information contained in these elements may be complete or it may
 *         be partial.
 * 
 *         
 * 
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="persistence-unit-metadata" type="{https://jakarta.ee/xml/ns/persistence/orm}persistence-unit-metadata" minOccurs="0"/>
 *         <element name="package" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="schema" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="access" type="{https://jakarta.ee/xml/ns/persistence/orm}access-type" minOccurs="0"/>
 *         <element name="sequence-generator" type="{https://jakarta.ee/xml/ns/persistence/orm}sequence-generator" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="table-generator" type="{https://jakarta.ee/xml/ns/persistence/orm}table-generator" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-query" type="{https://jakarta.ee/xml/ns/persistence/orm}named-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-native-query" type="{https://jakarta.ee/xml/ns/persistence/orm}named-native-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="named-stored-procedure-query" type="{https://jakarta.ee/xml/ns/persistence/orm}named-stored-procedure-query" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="sql-result-set-mapping" type="{https://jakarta.ee/xml/ns/persistence/orm}sql-result-set-mapping" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="mapped-superclass" type="{https://jakarta.ee/xml/ns/persistence/orm}mapped-superclass" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="entity" type="{https://jakarta.ee/xml/ns/persistence/orm}entity" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="embeddable" type="{https://jakarta.ee/xml/ns/persistence/orm}embeddable" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="converter" type="{https://jakarta.ee/xml/ns/persistence/orm}converter" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="version" use="required" type="{https://jakarta.ee/xml/ns/persistence/orm}versionType" fixed="3.1" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "description",
    "persistenceUnitMetadata",
    "_package",
    "schema",
    "catalog",
    "access",
    "sequenceGenerator",
    "tableGenerator",
    "namedQuery",
    "namedNativeQuery",
    "namedStoredProcedureQuery",
    "sqlResultSetMapping",
    "mappedSuperclass",
    "entity",
    "embeddable",
    "converter"
})
@XmlRootElement(name = "entity-mappings", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
public class EntityMappings {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(name = "persistence-unit-metadata", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PersistenceUnitMetadata persistenceUnitMetadata;
    @XmlElement(name = "package", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String _package;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String schema;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String catalog;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    @XmlSchemaType(name = "token")
    protected AccessType access;
    @XmlElement(name = "sequence-generator", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<SequenceGenerator> sequenceGenerator;
    @XmlElement(name = "table-generator", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<TableGenerator> tableGenerator;
    @XmlElement(name = "named-query", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedQuery> namedQuery;
    @XmlElement(name = "named-native-query", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedNativeQuery> namedNativeQuery;
    @XmlElement(name = "named-stored-procedure-query", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedStoredProcedureQuery> namedStoredProcedureQuery;
    @XmlElement(name = "sql-result-set-mapping", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<SqlResultSetMapping> sqlResultSetMapping;
    @XmlElement(name = "mapped-superclass", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<MappedSuperclass> mappedSuperclass;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Entity> entity;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Embeddable> embeddable;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Converter> converter;
    @XmlAttribute(name = "version", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String version;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the persistenceUnitMetadata property.
     * 
     * @return
     *     possible object is
     *     {@link PersistenceUnitMetadata }
     *     
     */
    public PersistenceUnitMetadata getPersistenceUnitMetadata() {
        return persistenceUnitMetadata;
    }

    /**
     * Sets the value of the persistenceUnitMetadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersistenceUnitMetadata }
     *     
     */
    public void setPersistenceUnitMetadata(PersistenceUnitMetadata value) {
        this.persistenceUnitMetadata = value;
    }

    /**
     * Gets the value of the package property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPackage() {
        return _package;
    }

    /**
     * Sets the value of the package property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPackage(String value) {
        this._package = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchema(String value) {
        this.schema = value;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link AccessType }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccessType }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the sequenceGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sequenceGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSequenceGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SequenceGenerator }
     * 
     * 
     * @return
     *     The value of the sequenceGenerator property.
     */
    public List<SequenceGenerator> getSequenceGenerator() {
        if (sequenceGenerator == null) {
            sequenceGenerator = new ArrayList<>();
        }
        return this.sequenceGenerator;
    }

    /**
     * Gets the value of the tableGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the tableGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTableGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TableGenerator }
     * 
     * 
     * @return
     *     The value of the tableGenerator property.
     */
    public List<TableGenerator> getTableGenerator() {
        if (tableGenerator == null) {
            tableGenerator = new ArrayList<>();
        }
        return this.tableGenerator;
    }

    /**
     * Gets the value of the namedQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedQuery }
     * 
     * 
     * @return
     *     The value of the namedQuery property.
     */
    public List<NamedQuery> getNamedQuery() {
        if (namedQuery == null) {
            namedQuery = new ArrayList<>();
        }
        return this.namedQuery;
    }

    /**
     * Gets the value of the namedNativeQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedNativeQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedNativeQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedNativeQuery }
     * 
     * 
     * @return
     *     The value of the namedNativeQuery property.
     */
    public List<NamedNativeQuery> getNamedNativeQuery() {
        if (namedNativeQuery == null) {
            namedNativeQuery = new ArrayList<>();
        }
        return this.namedNativeQuery;
    }

    /**
     * Gets the value of the namedStoredProcedureQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedStoredProcedureQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedStoredProcedureQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedStoredProcedureQuery }
     * 
     * 
     * @return
     *     The value of the namedStoredProcedureQuery property.
     */
    public List<NamedStoredProcedureQuery> getNamedStoredProcedureQuery() {
        if (namedStoredProcedureQuery == null) {
            namedStoredProcedureQuery = new ArrayList<>();
        }
        return this.namedStoredProcedureQuery;
    }

    /**
     * Gets the value of the sqlResultSetMapping property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sqlResultSetMapping property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSqlResultSetMapping().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SqlResultSetMapping }
     * 
     * 
     * @return
     *     The value of the sqlResultSetMapping property.
     */
    public List<SqlResultSetMapping> getSqlResultSetMapping() {
        if (sqlResultSetMapping == null) {
            sqlResultSetMapping = new ArrayList<>();
        }
        return this.sqlResultSetMapping;
    }

    /**
     * Gets the value of the mappedSuperclass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mappedSuperclass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMappedSuperclass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MappedSuperclass }
     * 
     * 
     * @return
     *     The value of the mappedSuperclass property.
     */
    public List<MappedSuperclass> getMappedSuperclass() {
        if (mappedSuperclass == null) {
            mappedSuperclass = new ArrayList<>();
        }
        return this.mappedSuperclass;
    }

    /**
     * Gets the value of the entity property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the entity property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntity().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Entity }
     * 
     * 
     * @return
     *     The value of the entity property.
     */
    public List<Entity> getEntity() {
        if (entity == null) {
            entity = new ArrayList<>();
        }
        return this.entity;
    }

    /**
     * Gets the value of the embeddable property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the embeddable property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbeddable().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Embeddable }
     * 
     * 
     * @return
     *     The value of the embeddable property.
     */
    public List<Embeddable> getEmbeddable() {
        if (embeddable == null) {
            embeddable = new ArrayList<>();
        }
        return this.embeddable;
    }

    /**
     * Gets the value of the converter property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the converter property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConverter().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Converter }
     * 
     * 
     * @return
     *     The value of the converter property.
     */
    public List<Converter> getConverter() {
        if (converter == null) {
            converter = new ArrayList<>();
        }
        return this.converter;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        if (version == null) {
            return "3.1";
        } else {
            return version;
        }
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
